/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.parquet.hadoop.rewrite;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.shade.org.apache.parquet.ParquetReadOptions;
import org.apache.paimon.shade.org.apache.parquet.Preconditions;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesInput;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnReader;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnWriteStore;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnWriter;
import org.apache.paimon.shade.org.apache.parquet.column.ParquetProperties;
import org.apache.paimon.shade.org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.paimon.shade.org.apache.parquet.column.page.DictionaryPage;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.shade.org.apache.parquet.column.statistics.Statistics;
import org.apache.paimon.shade.org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.paimon.shade.org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.paimon.shade.org.apache.parquet.conf.ParquetConfiguration;
import org.apache.paimon.shade.org.apache.parquet.crypto.AesCipher;
import org.apache.paimon.shade.org.apache.parquet.crypto.InternalColumnEncryptionSetup;
import org.apache.paimon.shade.org.apache.parquet.crypto.InternalFileEncryptor;
import org.apache.paimon.shade.org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.paimon.shade.org.apache.parquet.format.BlockCipher;
import org.apache.paimon.shade.org.apache.parquet.format.DataPageHeader;
import org.apache.paimon.shade.org.apache.parquet.format.DataPageHeaderV2;
import org.apache.paimon.shade.org.apache.parquet.format.DictionaryPageHeader;
import org.apache.paimon.shade.org.apache.parquet.format.PageHeader;
import org.apache.paimon.shade.org.apache.parquet.format.Statistics;
import org.apache.paimon.shade.org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.CodecFactory;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import org.apache.paimon.shade.org.apache.parquet.hadoop.IndexCache;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.paimon.shade.org.apache.parquet.hadoop.rewrite.MaskMode;
import org.apache.paimon.shade.org.apache.parquet.hadoop.rewrite.RewriteOptions;
import org.apache.paimon.shade.org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.util.HadoopCodecs;
import org.apache.paimon.shade.org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.paimon.shade.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.paimon.shade.org.apache.parquet.io.InputFile;
import org.apache.paimon.shade.org.apache.parquet.io.OutputFile;
import org.apache.paimon.shade.org.apache.parquet.io.ParquetEncodingException;
import org.apache.paimon.shade.org.apache.parquet.io.api.Converter;
import org.apache.paimon.shade.org.apache.parquet.io.api.GroupConverter;
import org.apache.paimon.shade.org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.paimon.shade.org.apache.parquet.schema.GroupType;
import org.apache.paimon.shade.org.apache.parquet.schema.InvalidSchemaException;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;
import org.apache.paimon.shade.org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRewriter
implements Closeable {
    public static final String ORIGINAL_CREATED_BY_KEY = "original.created.by";
    private static final Logger LOG = LoggerFactory.getLogger(ParquetRewriter.class);
    private final int pageBufferSize = 0x200000;
    private final byte[] pageBuffer = new byte[0x200000];
    private final CompressionCodecName newCodecName;
    private Map<ColumnPath, MaskMode> maskColumns = null;
    private Set<ColumnPath> encryptColumns = null;
    private boolean encryptMode = false;
    private final Map<String, String> extraMetaData;
    private final ParquetFileWriter writer;
    private int numBlocksRewritten = 0;
    private final Queue<CompressionConverter.TransParquetFileReader> inputFiles = new LinkedList<CompressionConverter.TransParquetFileReader>();
    private final Queue<CompressionConverter.TransParquetFileReader> inputFilesToJoin = new LinkedList<CompressionConverter.TransParquetFileReader>();
    private final MessageType outSchema;
    private final IndexCache.CacheStrategy indexCacheStrategy;
    private final boolean overwriteInputWithJoinColumns;
    private final InternalFileEncryptor nullColumnEncryptor;
    private final Map<String, String> renamedColumns;

    public ParquetRewriter(RewriteOptions options) throws IOException {
        this.newCodecName = options.getNewCodecName();
        this.indexCacheStrategy = options.getIndexCacheStrategy();
        this.overwriteInputWithJoinColumns = options.getOverwriteInputWithJoinColumns();
        this.renamedColumns = options.getRenameColumns();
        ParquetConfiguration conf = options.getParquetConfiguration();
        this.inputFiles.addAll(this.getFileReaders(options.getParquetInputFiles(), conf));
        this.inputFilesToJoin.addAll(this.getFileReaders(options.getParquetInputFilesToJoin(), conf));
        this.outSchema = this.pruneColumnsInSchema(this.getSchema(), options.getPruneColumns());
        this.extraMetaData = this.getExtraMetadata(options);
        this.ensureSameSchema(this.inputFiles);
        this.ensureSameSchema(this.inputFilesToJoin);
        this.ensureRowCount();
        this.ensureRenamingCorrectness(this.outSchema, this.renamedColumns);
        OutputFile out = options.getParquetOutputFile();
        LOG.info("Start rewriting {} input file(s) {} to {}", new Object[]{this.inputFiles.size() + this.inputFilesToJoin.size(), Stream.concat(options.getParquetInputFiles().stream(), options.getParquetInputFilesToJoin().stream()).collect(Collectors.toList()), out});
        if (options.getMaskColumns() != null) {
            this.maskColumns = new HashMap<ColumnPath, MaskMode>();
            for (Map.Entry<String, MaskMode> col : options.getMaskColumns().entrySet()) {
                this.maskColumns.put(ColumnPath.fromDotString(col.getKey()), col.getValue());
            }
        }
        if (options.getEncryptColumns() != null && options.getFileEncryptionProperties() != null) {
            this.encryptColumns = this.convertToColumnPaths(options.getEncryptColumns());
            this.encryptMode = true;
        }
        ParquetFileWriter.Mode writerMode = ParquetFileWriter.Mode.CREATE;
        this.writer = new ParquetFileWriter(out, this.renamedColumns.isEmpty() ? this.outSchema : this.getSchemaWithRenamedColumns(this.outSchema), writerMode, 0x8000000L, 0x800000, 64, Integer.MAX_VALUE, true, options.getFileEncryptionProperties());
        this.writer.start();
        if (options.getFileEncryptionProperties() == null) {
            this.nullColumnEncryptor = null;
        } else {
            this.nullColumnEncryptor = new InternalFileEncryptor(options.getFileEncryptionProperties());
            List<ColumnDescriptor> columns = this.getSchemaWithRenamedColumns(this.outSchema).getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                this.writer.getEncryptor().getColumnSetup(ColumnPath.get(columns.get(i).getPath()), true, i);
            }
        }
    }

    public ParquetRewriter(CompressionConverter.TransParquetFileReader reader, ParquetFileWriter writer, ParquetMetadata meta, MessageType outSchema, String originalCreatedBy, CompressionCodecName codecName, List<String> maskColumns, MaskMode maskMode) {
        this.writer = writer;
        this.outSchema = outSchema;
        this.newCodecName = codecName;
        this.extraMetaData = new HashMap<String, String>(meta.getFileMetaData().getKeyValueMetaData());
        this.extraMetaData.put(ORIGINAL_CREATED_BY_KEY, originalCreatedBy != null ? originalCreatedBy : meta.getFileMetaData().getCreatedBy());
        if (maskColumns != null && maskMode != null) {
            this.maskColumns = new HashMap<ColumnPath, MaskMode>();
            for (String col : maskColumns) {
                this.maskColumns.put(ColumnPath.fromDotString(col), maskMode);
            }
        }
        this.inputFiles.add(reader);
        this.indexCacheStrategy = IndexCache.CacheStrategy.NONE;
        this.overwriteInputWithJoinColumns = false;
        this.nullColumnEncryptor = null;
        this.renamedColumns = new HashMap<String, String>();
    }

    private MessageType getSchema() {
        MessageType schemaMain = this.inputFiles.peek().getFooter().getFileMetaData().getSchema();
        if (this.inputFilesToJoin.isEmpty()) {
            return schemaMain;
        }
        LinkedHashMap fieldNames = new LinkedHashMap();
        schemaMain.getFields().forEach(x -> fieldNames.put(x.getName(), x));
        this.inputFilesToJoin.peek().getFooter().getFileMetaData().getSchema().getFields().forEach(x -> {
            if (!fieldNames.containsKey(x.getName())) {
                fieldNames.put(x.getName(), x);
            } else if (this.overwriteInputWithJoinColumns) {
                LOG.info("Column {} in inputFiles is overwritten by inputFilesToJoin side", (Object)x.getName());
                fieldNames.put(x.getName(), x);
            }
        });
        return new MessageType(schemaMain.getName(), new ArrayList<Type>(fieldNames.values()));
    }

    private MessageType getSchemaWithRenamedColumns(MessageType schema) {
        List<Type> fields = schema.getFields().stream().map(type -> {
            if (!this.renamedColumns.containsKey(type.getName())) {
                return type;
            }
            if (type.isPrimitive()) {
                return new PrimitiveType(type.getRepetition(), type.asPrimitiveType().getPrimitiveTypeName(), this.renamedColumns.get(type.getName()));
            }
            return new GroupType(type.getRepetition(), this.renamedColumns.get(type.getName()), type.asGroupType().getFields());
        }).collect(Collectors.toList());
        return new MessageType(schema.getName(), fields);
    }

    private Map<String, String> getExtraMetadata(RewriteOptions options) {
        List<CompressionConverter.TransParquetFileReader> allFiles = options.getIgnoreJoinFilesMetadata() ? new ArrayList<CompressionConverter.TransParquetFileReader>(this.inputFiles) : Stream.concat(this.inputFiles.stream(), this.inputFilesToJoin.stream()).collect(Collectors.toList());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(ORIGINAL_CREATED_BY_KEY, allFiles.stream().map(x -> x.getFooter().getFileMetaData().getCreatedBy()).collect(Collectors.toSet()).stream().reduce((a, b) -> a + "\n" + b).orElse(""));
        allFiles.forEach(x -> result.putAll(x.getFileMetaData().getKeyValueMetaData()));
        return result;
    }

    private void ensureRowCount() {
        List blocksRowCountsR;
        List blocksRowCountsL;
        if (!this.inputFilesToJoin.isEmpty() && !(blocksRowCountsL = this.inputFiles.stream().flatMap(x -> x.getFooter().getBlocks().stream().map(BlockMetaData::getRowCount)).collect(Collectors.toList())).equals(blocksRowCountsR = this.inputFilesToJoin.stream().flatMap(x -> x.getFooter().getBlocks().stream().map(BlockMetaData::getRowCount)).collect(Collectors.toList()))) {
            throw new IllegalArgumentException("The number of rows in each block must match! Left blocks row counts: " + blocksRowCountsL + ", right blocks row counts" + blocksRowCountsR + ".");
        }
    }

    private Queue<CompressionConverter.TransParquetFileReader> getFileReaders(List<InputFile> inputFiles, ParquetConfiguration conf) {
        LinkedList<CompressionConverter.TransParquetFileReader> inputFileReaders = new LinkedList<CompressionConverter.TransParquetFileReader>();
        for (InputFile inputFile : inputFiles) {
            try {
                CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader(inputFile, ParquetReadOptions.builder(conf).build());
                inputFileReaders.add(reader);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to open input file: " + inputFile, e);
            }
        }
        return inputFileReaders;
    }

    private void ensureSameSchema(Queue<CompressionConverter.TransParquetFileReader> inputFileReaders) {
        MessageType schema = null;
        for (CompressionConverter.TransParquetFileReader reader : inputFileReaders) {
            MessageType newSchema = reader.getFooter().getFileMetaData().getSchema();
            if (schema == null) {
                schema = newSchema;
                continue;
            }
            if (schema.equals((Object)newSchema)) continue;
            String file = reader.getFile();
            LOG.error("Input files have different schemas, expect: {}, input: {}, current file: {}", new Object[]{schema, newSchema, file});
            throw new InvalidSchemaException("Input files have different schemas, current file: " + file);
        }
    }

    private void ensureRenamingCorrectness(MessageType schema, Map<String, String> renameMap) {
        Set columns = schema.getFields().stream().map(Type::getName).collect(Collectors.toSet());
        renameMap.forEach((src, dst) -> {
            if (!columns.contains(src)) {
                String msg = String.format("Column to rename '%s' is not found in input files schema", src);
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            if (columns.contains(dst)) {
                String msg = String.format("Renamed column target name '%s' is already present in a schema", dst);
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.writer.end(this.extraMetaData);
    }

    public void processBlocks() throws IOException {
        ParquetFileReader readerToJoin = null;
        IndexCache indexCacheToJoin = null;
        int blockIdxToJoin = 0;
        List<ColumnDescriptor> outColumns = this.outSchema.getColumns();
        while (!this.inputFiles.isEmpty()) {
            CompressionConverter.TransParquetFileReader reader = this.inputFiles.poll();
            LOG.info("Rewriting input file: {}, remaining files: {}", (Object)reader.getFile(), (Object)this.inputFiles.size());
            ParquetMetadata meta = reader.getFooter();
            Set<ColumnPath> columnPaths = meta.getFileMetaData().getSchema().getColumns().stream().map(x -> ColumnPath.get(x.getPath())).collect(Collectors.toSet());
            IndexCache indexCache = IndexCache.create(reader, columnPaths, this.indexCacheStrategy, true);
            for (int blockIdx = 0; blockIdx < meta.getBlocks().size(); ++blockIdx) {
                BlockMetaData blockMetaData = meta.getBlocks().get(blockIdx);
                this.writer.startBlock(blockMetaData.getRowCount());
                indexCache.setBlockMetadata(blockMetaData);
                Map<ColumnPath, ColumnChunkMetaData> pathToChunk = blockMetaData.getColumns().stream().collect(Collectors.toMap(x -> x.getPath(), x -> x));
                if (!this.inputFilesToJoin.isEmpty()) {
                    if (readerToJoin == null || ++blockIdxToJoin == readerToJoin.getFooter().getBlocks().size()) {
                        if (readerToJoin != null) {
                            readerToJoin.close();
                        }
                        blockIdxToJoin = 0;
                        readerToJoin = this.inputFilesToJoin.poll();
                        Set<ColumnPath> columnPathsToJoin = readerToJoin.getFileMetaData().getSchema().getColumns().stream().map(x -> ColumnPath.get(x.getPath())).collect(Collectors.toSet());
                        if (indexCacheToJoin != null) {
                            indexCacheToJoin.clean();
                        }
                        indexCacheToJoin = IndexCache.create(readerToJoin, columnPathsToJoin, this.indexCacheStrategy, true);
                        indexCacheToJoin.setBlockMetadata(readerToJoin.getFooter().getBlocks().get(blockIdxToJoin));
                    } else {
                        indexCacheToJoin.setBlockMetadata(readerToJoin.getFooter().getBlocks().get(++blockIdxToJoin));
                    }
                }
                for (int outColumnIdx = 0; outColumnIdx < outColumns.size(); ++outColumnIdx) {
                    ColumnPath colPath = ColumnPath.get(outColumns.get(outColumnIdx).getPath());
                    if (readerToJoin != null) {
                        Optional<ColumnChunkMetaData> chunkToJoin = readerToJoin.getFooter().getBlocks().get(blockIdxToJoin).getColumns().stream().filter(x -> x.getPath().equals(colPath)).findFirst();
                        if (chunkToJoin.isPresent() && (this.overwriteInputWithJoinColumns || !columnPaths.contains(colPath))) {
                            this.processBlock((CompressionConverter.TransParquetFileReader)readerToJoin, blockIdxToJoin, outColumnIdx, indexCacheToJoin, chunkToJoin.get());
                            continue;
                        }
                        this.processBlock(reader, blockIdx, outColumnIdx, indexCache, pathToChunk.get(colPath));
                        continue;
                    }
                    this.processBlock(reader, blockIdx, outColumnIdx, indexCache, pathToChunk.get(colPath));
                }
                this.writer.endBlock();
                indexCache.clean();
                ++this.numBlocksRewritten;
            }
            indexCache.clean();
            LOG.info("Finish rewriting input file: {}", (Object)reader.getFile());
            reader.close();
        }
        if (readerToJoin != null) {
            readerToJoin.close();
        }
    }

    private ColumnPath normalizeFieldsInPath(ColumnPath path) {
        if (this.renamedColumns.isEmpty()) {
            return path;
        }
        String[] pathArray = path.toArray();
        pathArray[0] = this.renamedColumns.getOrDefault(pathArray[0], pathArray[0]);
        return ColumnPath.get(pathArray);
    }

    private PrimitiveType normalizeNameInType(PrimitiveType type) {
        if (this.renamedColumns.isEmpty()) {
            return type;
        }
        return new PrimitiveType(type.getRepetition(), type.asPrimitiveType().getPrimitiveTypeName(), this.renamedColumns.getOrDefault(type.getName(), type.getName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBlock(CompressionConverter.TransParquetFileReader reader, int blockIdx, int outColumnIdx, IndexCache indexCache, ColumnChunkMetaData chunk) throws IOException {
        boolean encryptColumn;
        if (chunk.isEncrypted()) {
            throw new IOException("Column " + chunk.getPath().toDotString() + " is already encrypted");
        }
        ColumnChunkMetaData chunkNormalized = chunk;
        if (!this.renamedColumns.isEmpty()) {
            chunkNormalized = ColumnChunkMetaData.get(this.normalizeFieldsInPath(chunk.getPath()), this.normalizeNameInType(chunk.getPrimitiveType()), chunk.getCodec(), chunk.getEncodingStats(), chunk.getEncodings(), chunk.getStatistics(), chunk.getFirstDataPageOffset(), chunk.getDictionaryPageOffset(), chunk.getValueCount(), chunk.getTotalSize(), chunk.getTotalUncompressedSize(), chunk.getSizeStatistics());
        }
        ColumnDescriptor descriptorOriginal = this.outSchema.getColumns().get(outColumnIdx);
        ColumnDescriptor descriptorRenamed = this.getSchemaWithRenamedColumns(this.outSchema).getColumns().get(outColumnIdx);
        BlockMetaData blockMetaData = reader.getFooter().getBlocks().get(blockIdx);
        String originalCreatedBy = reader.getFileMetaData().getCreatedBy();
        reader.setStreamPosition(chunk.getStartingPos());
        CompressionCodecName newCodecName = this.newCodecName == null ? chunk.getCodec() : this.newCodecName;
        boolean bl = encryptColumn = this.encryptMode && this.encryptColumns != null && this.encryptColumns.contains(chunk.getPath());
        if (this.maskColumns != null && this.maskColumns.containsKey(chunk.getPath())) {
            MaskMode maskMode = this.maskColumns.get(chunk.getPath());
            if (!maskMode.equals((Object)MaskMode.NULLIFY)) throw new UnsupportedOperationException("Only nullify is supported for now");
            Type.Repetition repetition = descriptorOriginal.getPrimitiveType().getRepetition();
            if (repetition.equals((Object)Type.Repetition.REQUIRED)) {
                throw new IOException("Required column [" + descriptorOriginal.getPrimitiveType().getName() + "] cannot be nullified");
            }
            this.nullifyColumn(reader, blockIdx, descriptorOriginal, chunk, this.writer, newCodecName, encryptColumn, originalCreatedBy);
            return;
        } else if (this.encryptMode || this.newCodecName != null) {
            ColumnChunkEncryptorRunTime columnChunkEncryptorRunTime = null;
            if (this.encryptMode) {
                columnChunkEncryptorRunTime = new ColumnChunkEncryptorRunTime(this.writer.getEncryptor(), chunk, this.numBlocksRewritten, outColumnIdx);
            }
            this.writer.startColumn(descriptorRenamed, chunk.getValueCount(), newCodecName);
            this.processChunk(reader, blockMetaData.getRowCount(), chunk, newCodecName, columnChunkEncryptorRunTime, encryptColumn, indexCache.getBloomFilter(chunk), indexCache.getColumnIndex(chunk), indexCache.getOffsetIndex(chunk), originalCreatedBy);
            this.writer.endColumn();
            return;
        } else {
            BloomFilter bloomFilter = indexCache.getBloomFilter(chunk);
            ColumnIndex columnIndex = indexCache.getColumnIndex(chunk);
            OffsetIndex offsetIndex = indexCache.getOffsetIndex(chunk);
            this.writer.appendColumnChunk(descriptorRenamed, reader.getStream(), chunkNormalized, bloomFilter, columnIndex, offsetIndex);
        }
    }

    private void processChunk(CompressionConverter.TransParquetFileReader reader, long blockRowCount, ColumnChunkMetaData chunk, CompressionCodecName newCodecName, ColumnChunkEncryptorRunTime columnChunkEncryptorRunTime, boolean encryptColumn, BloomFilter bloomFilter, ColumnIndex columnIndex, OffsetIndex offsetIndex, String originalCreatedBy) throws IOException {
        CompressionCodecFactory codecFactory = HadoopCodecs.newFactory(0);
        CompressionCodecFactory.BytesInputDecompressor decompressor = null;
        CompressionCodecFactory.BytesInputCompressor compressor = null;
        if (!newCodecName.equals((Object)chunk.getCodec())) {
            decompressor = codecFactory.getDecompressor(chunk.getCodec());
            compressor = codecFactory.getCompressor(newCodecName);
        }
        BlockCipher.Encryptor metaEncryptor = null;
        BlockCipher.Encryptor dataEncryptor = null;
        byte[] dictPageAAD = null;
        byte[] dataPageAAD = null;
        byte[] dictPageHeaderAAD = null;
        byte[] dataPageHeaderAAD = null;
        if (columnChunkEncryptorRunTime != null) {
            metaEncryptor = columnChunkEncryptorRunTime.getMetaDataEncryptor();
            dataEncryptor = columnChunkEncryptorRunTime.getDataEncryptor();
            dictPageAAD = columnChunkEncryptorRunTime.getDictPageAAD();
            dataPageAAD = columnChunkEncryptorRunTime.getDataPageAAD();
            dictPageHeaderAAD = columnChunkEncryptorRunTime.getDictPageHeaderAAD();
            dataPageHeaderAAD = columnChunkEncryptorRunTime.getDataPageHeaderAAD();
        }
        if (bloomFilter != null) {
            this.writer.addBloomFilter(this.normalizeFieldsInPath(chunk.getPath()).toDotString(), bloomFilter);
        }
        reader.setStreamPosition(chunk.getStartingPos());
        DictionaryPage dictionaryPage = null;
        long readValues = 0L;
        long readRows = 0L;
        org.apache.paimon.shade.org.apache.parquet.column.statistics.Statistics<?> statistics = null;
        boolean isColumnStatisticsMalformed = false;
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        int pageOrdinal = 0;
        long totalChunkValues = chunk.getValueCount();
        block5: while (readValues < totalChunkValues) {
            PageHeader pageHeader = reader.readPageHeader();
            int compressedPageSize = pageHeader.getCompressed_page_size();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    if (dictionaryPage != null) {
                        throw new IOException("has more than one dictionary page in column chunk: " + chunk);
                    }
                    DictionaryPageHeader dictPageHeader = pageHeader.dictionary_page_header;
                    byte[] pageLoad = this.processPageLoad(reader, true, compressor, decompressor, pageHeader.getCompressed_page_size(), pageHeader.getUncompressed_page_size(), encryptColumn, dataEncryptor, dictPageAAD);
                    dictionaryPage = new DictionaryPage(BytesInput.from(pageLoad), pageHeader.getUncompressed_page_size(), dictPageHeader.getNum_values(), converter.getEncoding(dictPageHeader.getEncoding()));
                    this.writer.writeDictionaryPage(dictionaryPage, metaEncryptor, dictPageHeaderAAD);
                    continue block5;
                }
                case DATA_PAGE: {
                    if (encryptColumn) {
                        AesCipher.quickUpdatePageAAD(dataPageHeaderAAD, pageOrdinal);
                        AesCipher.quickUpdatePageAAD(dataPageAAD, pageOrdinal);
                    }
                    DataPageHeader headerV1 = pageHeader.data_page_header;
                    byte[] pageLoad = this.processPageLoad(reader, true, compressor, decompressor, pageHeader.getCompressed_page_size(), pageHeader.getUncompressed_page_size(), encryptColumn, dataEncryptor, dataPageAAD);
                    statistics = this.convertStatistics(originalCreatedBy, this.normalizeNameInType(chunk.getPrimitiveType()), headerV1.getStatistics(), columnIndex, pageOrdinal, converter);
                    if (statistics == null) {
                        isColumnStatisticsMalformed = true;
                    } else {
                        Preconditions.checkState(!isColumnStatisticsMalformed, "Detected mixed null page statistics and non-null page statistics");
                    }
                    readValues += (long)headerV1.getNum_values();
                    if (offsetIndex != null) {
                        long rowCount = 1L + offsetIndex.getLastRowIndex(pageOrdinal, blockRowCount) - offsetIndex.getFirstRowIndex(pageOrdinal);
                        readRows += rowCount;
                        this.writer.writeDataPage(this.toIntWithCheck(headerV1.getNum_values()), pageHeader.getUncompressed_page_size(), BytesInput.from(pageLoad), statistics, this.toIntWithCheck(rowCount), converter.getEncoding(headerV1.getRepetition_level_encoding()), converter.getEncoding(headerV1.getDefinition_level_encoding()), converter.getEncoding(headerV1.getEncoding()), metaEncryptor, dataPageHeaderAAD);
                    } else {
                        this.writer.writeDataPage(this.toIntWithCheck(headerV1.getNum_values()), pageHeader.getUncompressed_page_size(), BytesInput.from(pageLoad), statistics, converter.getEncoding(headerV1.getRepetition_level_encoding()), converter.getEncoding(headerV1.getDefinition_level_encoding()), converter.getEncoding(headerV1.getEncoding()), metaEncryptor, dataPageHeaderAAD);
                    }
                    ++pageOrdinal;
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    if (encryptColumn) {
                        AesCipher.quickUpdatePageAAD(dataPageHeaderAAD, pageOrdinal);
                        AesCipher.quickUpdatePageAAD(dataPageAAD, pageOrdinal);
                    }
                    DataPageHeaderV2 headerV2 = pageHeader.data_page_header_v2;
                    int rlLength = headerV2.getRepetition_levels_byte_length();
                    BytesInput rlLevels = this.readBlockAllocate(rlLength, reader);
                    int dlLength = headerV2.getDefinition_levels_byte_length();
                    BytesInput dlLevels = this.readBlockAllocate(dlLength, reader);
                    int payLoadLength = pageHeader.getCompressed_page_size() - rlLength - dlLength;
                    int rawDataLength = pageHeader.getUncompressed_page_size() - rlLength - dlLength;
                    byte[] pageLoad = this.processPageLoad(reader, headerV2.is_compressed, compressor, decompressor, payLoadLength, rawDataLength, encryptColumn, dataEncryptor, dataPageAAD);
                    statistics = this.convertStatistics(originalCreatedBy, this.normalizeNameInType(chunk.getPrimitiveType()), headerV2.getStatistics(), columnIndex, pageOrdinal, converter);
                    if (statistics == null) {
                        isColumnStatisticsMalformed = true;
                    } else {
                        Preconditions.checkState(!isColumnStatisticsMalformed, "Detected mixed null page statistics and non-null page statistics");
                    }
                    readValues += (long)headerV2.getNum_values();
                    readRows += (long)headerV2.getNum_rows();
                    this.writer.writeDataPageV2(headerV2.getNum_rows(), headerV2.getNum_nulls(), headerV2.getNum_values(), rlLevels, dlLevels, converter.getEncoding(headerV2.getEncoding()), BytesInput.from(pageLoad), rawDataLength, statistics, metaEncryptor, dataPageHeaderAAD);
                    ++pageOrdinal;
                    continue block5;
                }
            }
            LOG.debug("skipping page of type {} of size {}", (Object)pageHeader.getType(), (Object)compressedPageSize);
        }
        Preconditions.checkState(readRows == 0L || readRows == blockRowCount, "Read row count: %s not match with block total row count: %s", (Object)readRows, (Object)blockRowCount);
        if (isColumnStatisticsMalformed) {
            this.writer.invalidateStatistics(chunk.getStatistics());
        }
    }

    private org.apache.paimon.shade.org.apache.parquet.column.statistics.Statistics<?> convertStatistics(String createdBy, PrimitiveType type, Statistics pageStatistics, ColumnIndex columnIndex, int pageIndex, ParquetMetadataConverter converter) throws IOException {
        if (columnIndex != null) {
            if (columnIndex.getNullPages() == null) {
                throw new IOException("columnIndex has null variable 'nullPages' which indicates corrupted data for type: " + type.getName());
            }
            if (pageIndex > columnIndex.getNullPages().size()) {
                throw new IOException("There are more pages " + pageIndex + " found in the column than in the columnIndex " + columnIndex.getNullPages().size());
            }
            Statistics.Builder statsBuilder = org.apache.paimon.shade.org.apache.parquet.column.statistics.Statistics.getBuilderForReading(type);
            statsBuilder.withNumNulls(columnIndex.getNullCounts().get(pageIndex));
            if (!columnIndex.getNullPages().get(pageIndex).booleanValue()) {
                statsBuilder.withMin((byte[])columnIndex.getMinValues().get(pageIndex).array().clone());
                statsBuilder.withMax((byte[])columnIndex.getMaxValues().get(pageIndex).array().clone());
            }
            return statsBuilder.build();
        }
        if (pageStatistics != null) {
            return converter.fromParquetStatistics(createdBy, pageStatistics, type);
        }
        return null;
    }

    private byte[] processPageLoad(CompressionConverter.TransParquetFileReader reader, boolean isCompressed, CompressionCodecFactory.BytesInputCompressor compressor, CompressionCodecFactory.BytesInputDecompressor decompressor, int payloadLength, int rawDataLength, boolean encrypt, BlockCipher.Encryptor dataEncryptor, byte[] AAD) throws IOException {
        BytesInput data = this.readBlock(payloadLength, reader);
        if (compressor != null) {
            if (isCompressed) {
                data = decompressor.decompress(data, rawDataLength);
            }
            data = compressor.compress(data);
        }
        if (!encrypt) {
            return data.toByteArray();
        }
        return dataEncryptor.encrypt(data.toByteArray(), AAD);
    }

    public BytesInput readBlock(int length, CompressionConverter.TransParquetFileReader reader) throws IOException {
        byte[] data = length > 0x200000 ? new byte[length] : this.pageBuffer;
        reader.blockRead(data, 0, length);
        return BytesInput.from(data, 0, length);
    }

    public BytesInput readBlockAllocate(int length, CompressionConverter.TransParquetFileReader reader) throws IOException {
        byte[] data = new byte[length];
        reader.blockRead(data, 0, length);
        return BytesInput.from(data, 0, length);
    }

    private int toIntWithCheck(long size) {
        if ((long)((int)size) != size) {
            throw new ParquetEncodingException("size is bigger than 2147483647 bytes: " + size);
        }
        return (int)size;
    }

    private void getPaths(GroupType schema, List<String> paths, String parent) {
        List<Type> fields = schema.getFields();
        String prefix = parent == null ? "" : parent + ".";
        for (Type field : fields) {
            paths.add(prefix + field.getName());
            if (!(field instanceof GroupType)) continue;
            this.getPaths(field.asGroupType(), paths, prefix + field.getName());
        }
    }

    private MessageType pruneColumnsInSchema(MessageType schema, List<String> pruneColumns) {
        if (pruneColumns == null || pruneColumns.isEmpty()) {
            return schema;
        }
        ArrayList<String> paths = new ArrayList<String>();
        this.getPaths(schema, paths, null);
        for (String col : pruneColumns) {
            if (paths.contains(col)) continue;
            LOG.warn("Input column name {} doesn't show up in the schema", (Object)col);
        }
        Set<ColumnPath> prunePaths = this.convertToColumnPaths(pruneColumns);
        List<Type> fields = schema.getFields();
        ArrayList<String> currentPath = new ArrayList<String>();
        List<Type> prunedFields = this.pruneColumnsInFields(fields, currentPath, prunePaths);
        return new MessageType(schema.getName(), prunedFields);
    }

    private List<Type> pruneColumnsInFields(List<Type> fields, List<String> currentPath, Set<ColumnPath> prunePaths) {
        ArrayList<Type> prunedFields = new ArrayList<Type>();
        for (Type childField : fields) {
            Type prunedChildField = this.pruneColumnsInField(childField, currentPath, prunePaths);
            if (prunedChildField == null) continue;
            prunedFields.add(prunedChildField);
        }
        return prunedFields;
    }

    private Type pruneColumnsInField(Type field, List<String> currentPath, Set<ColumnPath> prunePaths) {
        String fieldName = field.getName();
        currentPath.add(fieldName);
        ColumnPath path = ColumnPath.get(currentPath.toArray(new String[0]));
        Type prunedField = null;
        if (!prunePaths.contains(path)) {
            if (field.isPrimitive()) {
                prunedField = field;
            } else {
                List<Type> childFields = ((GroupType)field).getFields();
                List<Type> prunedFields = this.pruneColumnsInFields(childFields, currentPath, prunePaths);
                if (!prunedFields.isEmpty()) {
                    prunedField = ((GroupType)field).withNewFields(prunedFields);
                }
            }
        }
        currentPath.remove(currentPath.size() - 1);
        return prunedField;
    }

    private Set<ColumnPath> convertToColumnPaths(List<String> cols) {
        HashSet<ColumnPath> prunePaths = new HashSet<ColumnPath>();
        for (String col : cols) {
            prunePaths.add(ColumnPath.fromDotString(col));
        }
        return prunePaths;
    }

    private void nullifyColumn(CompressionConverter.TransParquetFileReader reader, int blockIndex, ColumnDescriptor descriptor, ColumnChunkMetaData chunk, ParquetFileWriter writer, CompressionCodecName newCodecName, boolean encryptColumn, String originalCreatedBy) throws IOException {
        if (encryptColumn) {
            Preconditions.checkArgument(writer.getEncryptor() != null, "Missing encryptor");
        }
        long totalChunkValues = chunk.getValueCount();
        int dMax = descriptor.getMaxDefinitionLevel();
        PageReadStore pageReadStore = reader.readRowGroup(blockIndex);
        ColumnReadStoreImpl crStore = new ColumnReadStoreImpl(pageReadStore, new DummyGroupConverter(), this.outSchema, originalCreatedBy);
        ColumnReader cReader = crStore.getColumnReader(descriptor);
        ParquetProperties.WriterVersion writerVersion = chunk.getEncodingStats().usesV2Pages() ? ParquetProperties.WriterVersion.PARQUET_2_0 : ParquetProperties.WriterVersion.PARQUET_1_0;
        ParquetProperties props = ParquetProperties.builder().withWriterVersion(writerVersion).build();
        CodecFactory codecFactory = new CodecFactory(new Configuration(), props.getPageSizeThreshold());
        CodecFactory.BytesCompressor compressor = codecFactory.getCompressor(newCodecName);
        MessageType newSchema = this.getSchemaWithRenamedColumns(this.newSchema(this.outSchema, descriptor));
        ColumnChunkPageWriteStore cPageStore = new ColumnChunkPageWriteStore((CompressionCodecFactory.BytesInputCompressor)compressor, newSchema, props.getAllocator(), props.getColumnIndexTruncateLength(), props.getPageWriteChecksumEnabled(), this.nullColumnEncryptor, this.numBlocksRewritten);
        ColumnWriteStore cStore = props.newColumnWriteStore(newSchema, cPageStore);
        ColumnWriter cWriter = cStore.getColumnWriter(descriptor);
        int i = 0;
        while ((long)i < totalChunkValues) {
            int rlvl = cReader.getCurrentRepetitionLevel();
            int dlvl = cReader.getCurrentDefinitionLevel();
            if (dlvl == dMax) {
                if (dlvl == 0) {
                    throw new IOException("definition level is detected to be 0 for column " + chunk.getPath().toDotString() + " to be nullified");
                }
                if (rlvl == 0) {
                    cWriter.writeNull(rlvl, dlvl - 1);
                }
            } else {
                cWriter.writeNull(rlvl, dlvl);
            }
            cStore.endRecord();
            ++i;
        }
        pageReadStore.close();
        cStore.flush();
        cPageStore.flushToFileWriter(writer);
        cStore.close();
        cWriter.close();
    }

    private MessageType newSchema(MessageType schema, ColumnDescriptor descriptor) {
        String[] path = descriptor.getPath();
        Type type = schema.getType(path);
        if (path.length == 1) {
            return new MessageType(schema.getName(), type);
        }
        for (Type field : schema.getFields()) {
            Type newType;
            if (field.isPrimitive() || (newType = this.extractField(field.asGroupType(), type)) == null) continue;
            return new MessageType(schema.getName(), newType);
        }
        throw new RuntimeException("No field is found");
    }

    private Type extractField(GroupType candidate, Type targetField) {
        if (targetField.equals((Object)candidate)) {
            return targetField;
        }
        for (Type field : candidate.asGroupType().getFields()) {
            if (field.isPrimitive()) {
                if (!field.equals((Object)targetField)) continue;
                return new GroupType(candidate.getRepetition(), candidate.getName(), targetField);
            }
            Type tempField = this.extractField(field.asGroupType(), targetField);
            if (tempField == null) continue;
            return new GroupType(candidate.getRepetition(), candidate.getName(), tempField);
        }
        return null;
    }

    private static class ColumnChunkEncryptorRunTime {
        private final InternalColumnEncryptionSetup colEncrSetup;
        private final BlockCipher.Encryptor dataEncryptor;
        private final BlockCipher.Encryptor metaDataEncryptor;
        private final byte[] fileAAD;
        private final byte[] dataPageHeaderAAD;
        private final byte[] dataPageAAD;
        private final byte[] dictPageHeaderAAD;
        private final byte[] dictPageAAD;

        public ColumnChunkEncryptorRunTime(InternalFileEncryptor fileEncryptor, ColumnChunkMetaData chunk, int blockId, int columnId) throws IOException {
            Preconditions.checkArgument(fileEncryptor != null, "FileEncryptor is required to create ColumnChunkEncryptorRunTime");
            this.colEncrSetup = fileEncryptor.getColumnSetup(chunk.getPath(), true, columnId);
            this.dataEncryptor = this.colEncrSetup.getDataEncryptor();
            this.metaDataEncryptor = this.colEncrSetup.getMetaDataEncryptor();
            this.fileAAD = fileEncryptor.getFileAAD();
            if (this.colEncrSetup != null && this.colEncrSetup.isEncrypted()) {
                this.dataPageHeaderAAD = this.createAAD(ModuleCipherFactory.ModuleType.DataPageHeader, blockId, columnId);
                this.dataPageAAD = this.createAAD(ModuleCipherFactory.ModuleType.DataPage, blockId, columnId);
                this.dictPageHeaderAAD = this.createAAD(ModuleCipherFactory.ModuleType.DictionaryPageHeader, blockId, columnId);
                this.dictPageAAD = this.createAAD(ModuleCipherFactory.ModuleType.DictionaryPage, blockId, columnId);
            } else {
                this.dataPageHeaderAAD = null;
                this.dataPageAAD = null;
                this.dictPageHeaderAAD = null;
                this.dictPageAAD = null;
            }
        }

        private byte[] createAAD(ModuleCipherFactory.ModuleType moduleType, int blockId, int columnId) {
            return AesCipher.createModuleAAD(this.fileAAD, moduleType, blockId, columnId, 0);
        }

        public BlockCipher.Encryptor getDataEncryptor() {
            return this.dataEncryptor;
        }

        public BlockCipher.Encryptor getMetaDataEncryptor() {
            return this.metaDataEncryptor;
        }

        public byte[] getDataPageHeaderAAD() {
            return this.dataPageHeaderAAD;
        }

        public byte[] getDataPageAAD() {
            return this.dataPageAAD;
        }

        public byte[] getDictPageHeaderAAD() {
            return this.dictPageHeaderAAD;
        }

        public byte[] getDictPageAAD() {
            return this.dictPageAAD;
        }
    }

    private static final class DummyConverter
    extends PrimitiveConverter {
        private DummyConverter() {
        }

        @Override
        public GroupConverter asGroupConverter() {
            return new DummyGroupConverter();
        }
    }

    private static final class DummyGroupConverter
    extends GroupConverter {
        private DummyGroupConverter() {
        }

        @Override
        public void start() {
        }

        @Override
        public void end() {
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return new DummyConverter();
        }
    }
}

