/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.writer;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.format.parquet.writer.ParquetRowDataWriter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.paimon.shade.org.apache.parquet.io.OutputFile;
import org.apache.paimon.shade.org.apache.parquet.io.api.RecordConsumer;
import org.apache.paimon.shade.org.apache.parquet.schema.MessageType;
import org.apache.paimon.types.RowType;

public class ParquetRowDataBuilder
extends ParquetWriter.Builder<InternalRow, ParquetRowDataBuilder> {
    private final RowType rowType;

    public ParquetRowDataBuilder(OutputFile path, RowType rowType) {
        super(path);
        this.rowType = rowType;
    }

    @Override
    protected ParquetRowDataBuilder self() {
        return this;
    }

    @Override
    protected WriteSupport<InternalRow> getWriteSupport(Configuration conf) {
        return new ParquetWriteSupport();
    }

    private class ParquetWriteSupport
    extends WriteSupport<InternalRow> {
        private final MessageType schema;
        private ParquetRowDataWriter writer;

        private ParquetWriteSupport() {
            this.schema = ParquetSchemaConverter.convertToParquetMessageType(ParquetRowDataBuilder.this.rowType);
        }

        @Override
        public WriteSupport.WriteContext init(Configuration configuration) {
            return new WriteSupport.WriteContext(this.schema, new HashMap<String, String>());
        }

        @Override
        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.writer = new ParquetRowDataWriter(recordConsumer, ParquetRowDataBuilder.this.rowType, this.schema);
        }

        @Override
        public void write(InternalRow record) {
            try {
                this.writer.write(record);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

