/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.reader;

import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.format.orc.reader.OrcArrayColumnVector;
import org.apache.paimon.format.orc.reader.OrcBytesColumnVector;
import org.apache.paimon.format.orc.reader.OrcDecimalColumnVector;
import org.apache.paimon.format.orc.reader.OrcDoubleColumnVector;
import org.apache.paimon.format.orc.reader.OrcLegacyTimestampColumnVector;
import org.apache.paimon.format.orc.reader.OrcLongColumnVector;
import org.apache.paimon.format.orc.reader.OrcMapColumnVector;
import org.apache.paimon.format.orc.reader.OrcRowColumnVector;
import org.apache.paimon.format.orc.reader.OrcTimestampColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;

public abstract class AbstractOrcColumnVector
implements ColumnVector {
    private final org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector vector;
    private final VectorizedRowBatch orcBatch;

    AbstractOrcColumnVector(org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector vector, VectorizedRowBatch orcBatch) {
        this.vector = vector;
        this.orcBatch = orcBatch;
    }

    protected int rowMapper(int r) {
        if (this.vector.isRepeating) {
            return 0;
        }
        return this.orcBatch.selectedInUse ? this.orcBatch.getSelected()[r] : r;
    }

    public boolean isNullAt(int i) {
        return !this.vector.noNulls && this.vector.isNull[this.rowMapper(i)];
    }

    public static ColumnVector createPaimonVector(org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.ColumnVector vector, VectorizedRowBatch orcBatch, DataType dataType, boolean legacyTimestampLtzType) {
        if (vector instanceof LongColumnVector) {
            if (dataType.getTypeRoot() == DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) {
                return new OrcLegacyTimestampColumnVector((LongColumnVector)vector, orcBatch);
            }
            return new OrcLongColumnVector((LongColumnVector)vector, orcBatch);
        }
        if (vector instanceof DoubleColumnVector) {
            return new OrcDoubleColumnVector((DoubleColumnVector)vector, orcBatch);
        }
        if (vector instanceof BytesColumnVector) {
            return new OrcBytesColumnVector((BytesColumnVector)vector, orcBatch);
        }
        if (vector instanceof DecimalColumnVector) {
            return new OrcDecimalColumnVector((DecimalColumnVector)vector, orcBatch);
        }
        if (vector instanceof TimestampColumnVector) {
            return new OrcTimestampColumnVector(vector, orcBatch, dataType, legacyTimestampLtzType);
        }
        if (vector instanceof ListColumnVector) {
            return new OrcArrayColumnVector((ListColumnVector)vector, orcBatch, (ArrayType)dataType, legacyTimestampLtzType);
        }
        if (vector instanceof StructColumnVector) {
            return new OrcRowColumnVector((StructColumnVector)vector, orcBatch, (RowType)dataType, legacyTimestampLtzType);
        }
        if (vector instanceof MapColumnVector) {
            return new OrcMapColumnVector((MapColumnVector)vector, orcBatch, (MapType)dataType, legacyTimestampLtzType);
        }
        throw new UnsupportedOperationException("Unsupported vector: " + vector.getClass().getName());
    }
}

