/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Audit;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.model.ModelVersion;

public class ModelVersionDTO
implements ModelVersion {
    @JsonProperty(value="version")
    private int version;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="aliases")
    private String[] aliases;
    @JsonProperty(value="uri")
    private String uri;
    @JsonProperty(value="uris")
    private Map<String, String> uris;
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="audit")
    private AuditDTO audit;

    @Override
    public Audit auditInfo() {
        return this.audit;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public String[] aliases() {
        return this.aliases;
    }

    @Override
    public Map<String, String> uris() {
        return this.uris;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ModelVersionDTO() {
    }

    private ModelVersionDTO(int version, String comment, String[] aliases, String uri, Map<String, String> uris, Map<String, String> properties, AuditDTO audit) {
        this.version = version;
        this.comment = comment;
        this.aliases = aliases;
        this.uri = uri;
        this.uris = uris;
        this.properties = properties;
        this.audit = audit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelVersionDTO)) {
            return false;
        }
        ModelVersionDTO other = (ModelVersionDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        if (!Arrays.deepEquals(this.aliases, other.aliases)) {
            return false;
        }
        String this$uri = this.uri;
        String other$uri = other.uri;
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        Map<String, String> this$uris = this.uris;
        Map<String, String> other$uris = other.uris;
        if (this$uris == null ? other$uris != null : !((Object)this$uris).equals(other$uris)) {
            return false;
        }
        Map<String, String> this$properties = this.properties;
        Map<String, String> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        AuditDTO this$audit = this.audit;
        AuditDTO other$audit = other.audit;
        return !(this$audit == null ? other$audit != null : !((Object)this$audit).equals(other$audit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelVersionDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.version;
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.aliases);
        String $uri = this.uri;
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        Map<String, String> $uris = this.uris;
        result = result * 59 + ($uris == null ? 43 : ((Object)$uris).hashCode());
        Map<String, String> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        AuditDTO $audit = this.audit;
        result = result * 59 + ($audit == null ? 43 : ((Object)$audit).hashCode());
        return result;
    }

    public static class Builder {
        private int version;
        private String comment;
        private String[] aliases;
        private Map<String, String> uris;
        private Map<String, String> properties;
        private AuditDTO audit;

        public Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withAliases(String[] aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder withUris(Map<String, String> uris) {
            this.uris = uris;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder withAudit(AuditDTO audit) {
            this.audit = audit;
            return this;
        }

        public ModelVersionDTO build() {
            Preconditions.checkArgument(this.version >= 0, "Version must be non-negative");
            Preconditions.checkArgument(this.audit != null, "Audit cannot be null");
            Preconditions.checkArgument(this.uris != null && !this.uris.isEmpty(), "At least one URI needs to be set for the model version");
            this.uris.forEach((n, u) -> {
                Preconditions.checkArgument(StringUtils.isNotBlank(n), "URI name must not be blank");
                Preconditions.checkArgument(StringUtils.isNotBlank(u), "URI must not be blank");
            });
            return new ModelVersionDTO(this.version, this.comment, this.aliases, this.uris.get("unknown"), this.uris, this.properties, this.audit);
        }
    }
}

