/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Map;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.Schema;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.client.MetadataObjectPolicyOperations;
import org.apache.gravitino.client.MetadataObjectRoleOperations;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.SchemaDTO;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.PolicyAlreadyAssociatedException;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.SupportsPolicies;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

class GenericSchema
implements Schema,
SupportsTags,
SupportsRoles,
SupportsPolicies {
    private final SchemaDTO schemaDTO;
    private final MetadataObjectTagOperations objectTagOperations;
    private final MetadataObjectRoleOperations objectRoleOperations;
    private final MetadataObjectPolicyOperations objectPolicyOperations;

    GenericSchema(SchemaDTO schemaDTO, RESTClient restClient, String metalake, String catalog) {
        this.schemaDTO = schemaDTO;
        MetadataObject schemaObject = MetadataObjects.of(catalog, schemaDTO.name(), MetadataObject.Type.SCHEMA);
        this.objectTagOperations = new MetadataObjectTagOperations(metalake, schemaObject, restClient);
        this.objectRoleOperations = new MetadataObjectRoleOperations(metalake, schemaObject, restClient);
        this.objectPolicyOperations = new MetadataObjectPolicyOperations(metalake, schemaObject, restClient);
    }

    @Override
    public SupportsTags supportsTags() {
        return this;
    }

    @Override
    public SupportsPolicies supportsPolicies() {
        return this;
    }

    @Override
    public SupportsRoles supportsRoles() {
        return this;
    }

    @Override
    public String name() {
        return this.schemaDTO.name();
    }

    @Override
    public String comment() {
        return this.schemaDTO.comment();
    }

    @Override
    public Map<String, String> properties() {
        return this.schemaDTO.properties();
    }

    @Override
    public Audit auditInfo() {
        return this.schemaDTO.auditInfo();
    }

    @Override
    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    @Override
    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    @Override
    public Tag getTag(String name) throws NoSuchTagException {
        return this.objectTagOperations.getTag(name);
    }

    @Override
    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }

    @Override
    public String[] listPolicies() {
        return this.objectPolicyOperations.listPolicies();
    }

    @Override
    public Policy[] listPolicyInfos() {
        return this.objectPolicyOperations.listPolicyInfos();
    }

    @Override
    public Policy getPolicy(String name) throws NoSuchPolicyException {
        return this.objectPolicyOperations.getPolicy(name);
    }

    @Override
    public String[] associatePolicies(String[] policiesToAdd, String[] policiesToRemove) throws PolicyAlreadyAssociatedException {
        return this.objectPolicyOperations.associatePolicies(policiesToAdd, policiesToRemove);
    }

    @Override
    public String[] listBindingRoleNames() {
        return this.objectRoleOperations.listBindingRoleNames();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericSchema)) {
            return false;
        }
        GenericSchema that = (GenericSchema)obj;
        return this.schemaDTO.equals(that.schemaDTO);
    }

    public int hashCode() {
        return this.schemaDTO.hashCode();
    }
}

