/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.outputs;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.outputs.OutputFormat;

public abstract class BaseOutputFormat<T>
implements OutputFormat<T> {
    protected CommandContext context;

    protected BaseOutputFormat(CommandContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void output(String message, OutputStream os) {
        if (message == null || os == null) {
            throw new IllegalArgumentException("Message and OutputStream cannot be null, message: " + message + ", os: " + String.valueOf(os));
        }
        boolean isSystemStream = os == System.out || os == System.err;
        try {
            PrintStream printStream = new PrintStream(isSystemStream ? os : new BufferedOutputStream(os), true, StandardCharsets.UTF_8.name());
            try {
                printStream.println(message);
                printStream.flush();
            }
            finally {
                if (!isSystemStream) {
                    printStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write message to output stream", e);
        }
    }

    @Override
    public void output(T entity) {
        String outputMessage = this.getOutput(entity);
        String output = outputMessage == null ? "" : outputMessage;
        BaseOutputFormat.output(output, System.out);
    }
}

