/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.tag.TagChange;

public class UpdateTagName
extends Command {
    protected final String metalake;
    protected final String tag;
    protected final String name;

    public UpdateTagName(CommandContext context, String metalake, String tag, String name) {
        super(context);
        this.metalake = metalake;
        this.tag = tag;
        this.name = name;
    }

    @Override
    public void handle() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            TagChange change = TagChange.rename(this.name);
            client.alterTag(this.tag, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchTagException err) {
            this.exitWithError("Unknown tag.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.tag + " name changed.");
    }
}

