/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.messaging.TopicChange;

public class RemoveTopicProperty
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String topic;
    protected final String property;

    public RemoveTopicProperty(CommandContext context, String metalake, String catalog, String schema, String topic, String property) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.topic = topic;
        this.property = property;
    }

    @Override
    public void handle() {
        NameIdentifier name = NameIdentifier.of(this.schema, this.topic);
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            TopicChange change = TopicChange.removeProperty(this.property);
            client.loadCatalog(this.catalog).asTopicCatalog().alterTopic(name, change);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTopicException err) {
            this.exitWithError("Unknown topic name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.property + " property removed.");
    }

    @Override
    public Command validate() {
        this.validateProperty(this.property);
        return super.validate();
    }
}

