/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelCatalog;

public class ModelDetails
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String model;

    public ModelDetails(CommandContext context, String metalake, String catalog, String schema, String model) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.model = model;
    }

    @Override
    public void handle() {
        NameIdentifier name = NameIdentifier.of(this.schema, this.model);
        Model gModel = null;
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            ModelCatalog modelCatalog = client.loadCatalog(this.catalog).asModelCatalog();
            gModel = modelCatalog.getModel(name);
        }
        catch (NoSuchMetalakeException noSuchMetalakeException) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException noSuchCatalogException) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException noSuchSchemaException) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchModelException noSuchModelException) {
            this.exitWithError("Unknown model name.");
        }
        catch (Exception err) {
            this.exitWithError(err.getMessage());
        }
        this.printResults(gModel);
    }
}

