/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;

public class DeleteModel
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String model;
    protected final boolean force;

    public DeleteModel(CommandContext context, String metalake, String catalog, String schema, String model) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.model = model;
    }

    @Override
    public void handle() {
        boolean deleted = false;
        if (!AreYouSure.really(this.force)) {
            return;
        }
        try (GravitinoClient client = this.buildClient(this.metalake);){
            NameIdentifier name = NameIdentifier.of(this.schema, this.model);
            deleted = client.loadCatalog(this.catalog).asModelCatalog().deleteModel(name);
        }
        catch (NoSuchMetalakeException noSuchMetalakeException) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException noSuchCatalogException) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException noSuchSchemaException) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchModelException noSuchModelException) {
            this.exitWithError("Unknown model name.");
        }
        catch (Exception err) {
            this.exitWithError(err.getMessage());
        }
        if (deleted) {
            this.printInformation(this.model + " deleted.");
        } else {
            this.printInformation(this.model + " not deleted.");
        }
    }
}

