/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import java.util.HashSet;
import org.apache.gravitino.authorization.Privilege;

public class Privileges {
    public static final String CREATE_CATALOG = "create_catalog";
    public static final String USE_CATALOG = "use_catalog";
    public static final String CREATE_SCHEMA = "create_schema";
    public static final String USE_SCHEMA = "use_schema";
    public static final String CREATE_TABLE = "create_table";
    public static final String MODIFY_TABLE = "modify_table";
    public static final String SELECT_TABLE = "select_table";
    public static final String CREATE_FILESET = "create_fileset";
    public static final String WRITE_FILESET = "write_fileset";
    public static final String READ_FILESET = "read_fileset";
    public static final String CREATE_TOPIC = "create_topic";
    public static final String PRODUCE_TOPIC = "produce_topic";
    public static final String CONSUME_TOPIC = "consume_topic";
    public static final String MANAGE_USERS = "manage_users";
    public static final String CREATE_ROLE = "create_role";
    public static final String MANAGE_GRANTS = "manage_grants";
    private static final HashSet<String> VALID_PRIVILEGES = new HashSet();

    public static boolean isValid(String privilege) {
        return VALID_PRIVILEGES.contains(privilege);
    }

    public static Privilege.Name toName(String privilege) {
        switch (privilege) {
            case "create_catalog": {
                return Privilege.Name.CREATE_CATALOG;
            }
            case "use_catalog": {
                return Privilege.Name.USE_CATALOG;
            }
            case "create_schema": {
                return Privilege.Name.CREATE_SCHEMA;
            }
            case "use_schema": {
                return Privilege.Name.USE_SCHEMA;
            }
            case "create_table": {
                return Privilege.Name.CREATE_TABLE;
            }
            case "modify_table": {
                return Privilege.Name.MODIFY_TABLE;
            }
            case "select_table": {
                return Privilege.Name.SELECT_TABLE;
            }
            case "create_fileset": {
                return Privilege.Name.CREATE_FILESET;
            }
            case "write_fileset": {
                return Privilege.Name.WRITE_FILESET;
            }
            case "read_fileset": {
                return Privilege.Name.READ_FILESET;
            }
            case "create_topic": {
                return Privilege.Name.CREATE_TOPIC;
            }
            case "produce_topic": {
                return Privilege.Name.PRODUCE_TOPIC;
            }
            case "consume_topic": {
                return Privilege.Name.CONSUME_TOPIC;
            }
            case "manage_users": {
                return Privilege.Name.MANAGE_USERS;
            }
            case "create_role": {
                return Privilege.Name.CREATE_ROLE;
            }
            case "manage_grants": {
                return Privilege.Name.MANAGE_GRANTS;
            }
        }
        System.err.println("Unknown privilege " + privilege);
        return null;
    }

    static {
        VALID_PRIVILEGES.add(CREATE_CATALOG);
        VALID_PRIVILEGES.add(USE_CATALOG);
        VALID_PRIVILEGES.add(CREATE_SCHEMA);
        VALID_PRIVILEGES.add(USE_SCHEMA);
        VALID_PRIVILEGES.add(CREATE_TABLE);
        VALID_PRIVILEGES.add(MODIFY_TABLE);
        VALID_PRIVILEGES.add(SELECT_TABLE);
        VALID_PRIVILEGES.add(CREATE_FILESET);
        VALID_PRIVILEGES.add(WRITE_FILESET);
        VALID_PRIVILEGES.add(READ_FILESET);
        VALID_PRIVILEGES.add(CREATE_TOPIC);
        VALID_PRIVILEGES.add(PRODUCE_TOPIC);
        VALID_PRIVILEGES.add(CONSUME_TOPIC);
        VALID_PRIVILEGES.add(MANAGE_USERS);
        VALID_PRIVILEGES.add(CREATE_ROLE);
        VALID_PRIVILEGES.add(MANAGE_GRANTS);
    }
}

