/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.audit;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;

public class CallerContext {
    private Map<String, String> context;

    private CallerContext() {
    }

    public Map<String, String> context() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallerContext)) {
            return false;
        }
        CallerContext context1 = (CallerContext)o;
        return Objects.equal(this.context, context1.context);
    }

    public int hashCode() {
        return Objects.hashCode(this.context);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final CallerContext callerContext = new CallerContext();

        private Builder() {
        }

        public Builder withContext(Map<String, String> context) {
            this.callerContext.context = context;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument(this.callerContext.context != null, "context cannot be null");
        }

        public CallerContext build() {
            this.validate();
            return this.callerContext;
        }
    }

    public static class CallerContextHolder {
        private static final ThreadLocal<CallerContext> CALLER_CONTEXT = new ThreadLocal();

        public static CallerContext get() {
            return CALLER_CONTEXT.get();
        }

        public static void set(CallerContext context) {
            CALLER_CONTEXT.set(context);
        }

        public static void remove() {
            CALLER_CONTEXT.remove();
        }
    }
}

