/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotSupportedException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.OperationDispatcher;
import org.apache.gravitino.connector.BaseCatalog;
import org.apache.gravitino.connector.credential.PathContext;
import org.apache.gravitino.connector.credential.SupportsPathBasedCredentials;
import org.apache.gravitino.credential.CatalogCredentialContext;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialPrivilege;
import org.apache.gravitino.credential.CredentialUtils;
import org.apache.gravitino.credential.PathBasedCredentialContext;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class CredentialOperationDispatcher
extends OperationDispatcher {
    public CredentialOperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        super(catalogManager, store, idGenerator);
    }

    public List<Credential> getCredentials(NameIdentifier identifier) {
        CredentialPrivilege privilege = this.getCredentialPrivilege(PrincipalUtils.getCurrentUserName(), identifier);
        return this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(identifier), catalogWrapper -> catalogWrapper.doWithCredentialOps(baseCatalog -> this.getCredentials((BaseCatalog)baseCatalog, identifier, privilege)), NoSuchCatalogException.class);
    }

    private List<Credential> getCredentials(BaseCatalog baseCatalog, NameIdentifier nameIdentifier, CredentialPrivilege privilege) {
        Map<String, CredentialContext> contexts = this.getCredentialContexts(baseCatalog, nameIdentifier, privilege);
        return contexts.entrySet().stream().map(entry -> baseCatalog.catalogCredentialManager().getCredential((String)entry.getKey(), (CredentialContext)entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map<String, CredentialContext> getCredentialContexts(BaseCatalog baseCatalog, NameIdentifier nameIdentifier, CredentialPrivilege privilege) {
        if (nameIdentifier.equals((Object)NameIdentifierUtil.getCatalogIdentifier(nameIdentifier))) {
            return this.getCatalogCredentialContexts(baseCatalog.properties());
        }
        if (baseCatalog.ops() instanceof SupportsPathBasedCredentials) {
            List<PathContext> pathContexts = ((SupportsPathBasedCredentials)((Object)baseCatalog.ops())).getPathContext(nameIdentifier);
            return CredentialOperationDispatcher.getPathBasedCredentialContexts(privilege, pathContexts);
        }
        throw new NotSupportedException(String.format("Catalog %s doesn't support generate credentials", baseCatalog.name()));
    }

    private Map<String, CredentialContext> getCatalogCredentialContexts(Map<String, String> catalogProperties) {
        CatalogCredentialContext context = new CatalogCredentialContext(PrincipalUtils.getCurrentUserName());
        Set<String> providers = CredentialUtils.getCredentialProvidersByOrder(() -> catalogProperties);
        return providers.stream().collect(Collectors.toMap(provider -> provider, provider -> context));
    }

    public static Map<String, CredentialContext> getPathBasedCredentialContexts(CredentialPrivilege privilege, List<PathContext> pathContexts) {
        return pathContexts.stream().collect(Collectors.toMap(pathContext -> pathContext.credentialType(), pathContext -> {
            String path = pathContext.path();
            HashSet<String> writePaths = new HashSet<String>();
            HashSet<String> readPaths = new HashSet<String>();
            if (CredentialPrivilege.WRITE.equals((Object)privilege)) {
                writePaths.add(path);
            } else {
                readPaths.add(path);
            }
            return new PathBasedCredentialContext(PrincipalUtils.getCurrentUserName(), writePaths, readPaths);
        }, CredentialOperationDispatcher::mergeContexts));
    }

    private static PathBasedCredentialContext mergeContexts(CredentialContext oldValue, CredentialContext newValue) {
        PathBasedCredentialContext oldContext = (PathBasedCredentialContext)oldValue;
        PathBasedCredentialContext newContext = (PathBasedCredentialContext)newValue;
        oldContext.getWritePaths().addAll(newContext.getWritePaths());
        oldContext.getReadPaths().addAll(newContext.getReadPaths());
        return oldContext;
    }

    private CredentialPrivilege getCredentialPrivilege(String user, NameIdentifier identifier) throws NotAuthorizedException {
        return CredentialPrivilege.WRITE;
    }
}

