/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class FamilyFilter
extends CompareFilter {
    @Deprecated
    public FamilyFilter(CompareFilter.CompareOp familyCompareOp, ByteArrayComparable familyComparator) {
        super(familyCompareOp, familyComparator);
    }

    public FamilyFilter(CompareOperator op, ByteArrayComparable familyComparator) {
        super(op, familyComparator);
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        byte familyLength = c.getFamilyLength();
        if (familyLength > 0 && this.compareFamily(this.getCompareOperator(), this.comparator, c)) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        ArrayList<Object> arguments = CompareFilter.extractArguments(filterArguments);
        CompareOperator compareOp = (CompareOperator)((Object)arguments.get(0));
        ByteArrayComparable comparator = (ByteArrayComparable)arguments.get(1);
        return new FamilyFilter(compareOp, comparator);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.FamilyFilter.Builder builder = FilterProtos.FamilyFilter.newBuilder();
        builder.setCompareFilter(super.convert());
        return builder.build().toByteArray();
    }

    public static FamilyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FamilyFilter proto;
        try {
            proto = FilterProtos.FamilyFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException((Throwable)e);
        }
        CompareOperator valueCompareOp = CompareOperator.valueOf(proto.getCompareFilter().getCompareOp().name());
        ByteArrayComparable valueComparator = null;
        try {
            if (proto.getCompareFilter().hasComparator()) {
                valueComparator = ProtobufUtil.toComparator(proto.getCompareFilter().getComparator());
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException((Throwable)ioe);
        }
        return new FamilyFilter(valueCompareOp, valueComparator);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FamilyFilter)) {
            return false;
        }
        FamilyFilter other = (FamilyFilter)o;
        return super.areSerializedFieldsEqual(other);
    }
}

