/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class RowMutations
implements Row {
    private final List<Mutation> mutations;
    private final byte[] row;

    public RowMutations(byte[] row) {
        this(row, -1);
    }

    public RowMutations(byte[] row, int initialCapacity) {
        Mutation.checkRow(row);
        this.row = Bytes.copy((byte[])row);
        this.mutations = initialCapacity <= 0 ? new ArrayList<Mutation>() : new ArrayList<Mutation>(initialCapacity);
    }

    public void add(Put p) throws IOException {
        this.internalAdd(p);
    }

    public void add(Delete d) throws IOException {
        this.internalAdd(d);
    }

    private void internalAdd(Mutation m) throws IOException {
        int res = Bytes.compareTo((byte[])this.row, (byte[])m.getRow());
        if (res != 0) {
            throw new WrongRowIOException("The row in the recently added Put/Delete <" + Bytes.toStringBinary((byte[])m.getRow()) + "> doesn't match the original one <" + Bytes.toStringBinary((byte[])this.row) + ">");
        }
        this.mutations.add(m);
    }

    @Override
    public int compareTo(Row i) {
        return Bytes.compareTo((byte[])this.getRow(), (byte[])i.getRow());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RowMutations) {
            RowMutations other = (RowMutations)obj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.row);
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public List<Mutation> getMutations() {
        return Collections.unmodifiableList(this.mutations);
    }

    public int getMaxPriority() {
        int maxPriority = Integer.MIN_VALUE;
        for (Mutation mutation : this.mutations) {
            maxPriority = Math.max(maxPriority, mutation.getPriority());
        }
        return maxPriority;
    }
}

