/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class NetworkTopologyServlet
extends DfsServlet {
    public static final String PATH_SPEC = "/topology";
    protected static final String FORMAT_JSON = "json";
    protected static final String FORMAT_TEXT = "text";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext context = this.getServletContext();
        String format = NetworkTopologyServlet.parseAcceptHeader(request);
        if (FORMAT_TEXT.equals(format)) {
            response.setContentType("text/plain; charset=UTF-8");
        } else if (FORMAT_JSON.equals(format)) {
            response.setContentType("application/json; charset=UTF-8");
        }
        NameNode nn = NameNodeHttpServer.getNameNodeFromContext(context);
        BlockManager bm = nn.getNamesystem().getBlockManager();
        List leaves = bm.getDatanodeManager().getNetworkTopology().getLeaves("");
        try (PrintStream out = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");){
            this.printTopology(out, leaves, format);
        }
        catch (Throwable t) {
            String errMsg = "Print network topology failed. " + StringUtils.stringifyException((Throwable)t);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }

    public void printTopology(PrintStream stream, List<Node> leaves, String format) throws BadFormatException, IOException {
        if (leaves.isEmpty()) {
            stream.print("No DataNodes");
            return;
        }
        HashMap<String, TreeSet<String>> tree = new HashMap<String, TreeSet<String>>();
        for (Node dni : leaves) {
            String location = dni.getNetworkLocation();
            String name = dni.getName();
            tree.putIfAbsent(location, new TreeSet());
            ((TreeSet)tree.get(location)).add(name);
        }
        ArrayList<String> racks = new ArrayList<String>(tree.keySet());
        Collections.sort(racks);
        if (FORMAT_JSON.equals(format)) {
            this.printJsonFormat(stream, tree, racks);
        } else if (FORMAT_TEXT.equals(format)) {
            this.printTextFormat(stream, tree, racks);
        } else {
            throw new BadFormatException("Bad format: " + format);
        }
    }

    private void printJsonFormat(PrintStream stream, Map<String, TreeSet<String>> tree, ArrayList<String> racks) throws IOException {
        JsonFactory dumpFactory = new JsonFactory();
        JsonGenerator dumpGenerator = dumpFactory.createGenerator((OutputStream)stream);
        dumpGenerator.writeStartArray();
        for (String r : racks) {
            dumpGenerator.writeStartObject();
            dumpGenerator.writeFieldName(r);
            TreeSet<String> nodes = tree.get(r);
            dumpGenerator.writeStartArray();
            for (String n : nodes) {
                dumpGenerator.writeStartObject();
                dumpGenerator.writeStringField("ip", n);
                String hostname = NetUtils.getHostNameOfIP((String)n);
                if (hostname != null) {
                    dumpGenerator.writeStringField("hostname", hostname);
                }
                dumpGenerator.writeEndObject();
            }
            dumpGenerator.writeEndArray();
            dumpGenerator.writeEndObject();
        }
        dumpGenerator.writeEndArray();
        dumpGenerator.flush();
        if (!dumpGenerator.isClosed()) {
            dumpGenerator.close();
        }
    }

    private void printTextFormat(PrintStream stream, Map<String, TreeSet<String>> tree, ArrayList<String> racks) {
        for (String r : racks) {
            stream.println("Rack: " + r);
            TreeSet<String> nodes = tree.get(r);
            for (String n : nodes) {
                stream.print("   " + n);
                String hostname = NetUtils.getHostNameOfIP((String)n);
                if (hostname != null) {
                    stream.print(" (" + hostname + ")");
                }
                stream.println();
            }
            stream.println();
        }
    }

    @VisibleForTesting
    static String parseAcceptHeader(HttpServletRequest request) {
        String format = request.getHeader("Accept");
        return format != null && format.contains(FORMAT_JSON) ? FORMAT_JSON : FORMAT_TEXT;
    }

    public static class BadFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadFormatException(String msg) {
            super(msg);
        }
    }
}

