/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.ipc;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.io.Serializable;
import org.apache.arrow.util.Preconditions;

public class ColumnOrdering
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final boolean nullFirst;
    private final boolean ascending;

    private ColumnOrdering(Builder builder) {
        this.columnName = (String)Preconditions.checkNotNull((Object)builder.columnName, (Object)"Columns must be set");
        Preconditions.checkArgument((!builder.columnName.isEmpty() ? 1 : 0) != 0, (Object)"Column must not be empty");
        this.nullFirst = builder.nullFirst;
        this.ascending = builder.ascending;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isNullFirst() {
        return this.nullFirst;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("columnName", this.columnName).add("nullFirst", this.nullFirst).add("ascending", this.ascending).toString();
    }

    public static class Builder {
        private String columnName;
        private boolean nullFirst = true;
        private boolean ascending = true;

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setNullFirst(boolean nullFirst) {
            this.nullFirst = nullFirst;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public ColumnOrdering build() {
            return new ColumnOrdering(this);
        }
    }
}

