/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.Map;

public class ManifestSummary {
    private static final String TOTAL_FRAGMENTS_KEY = "total_fragments";
    private static final String TOTAL_DATA_FILES_KEY = "total_data_files";
    private static final String TOTAL_FILES_SIZE_KEY = "total_files_size";
    private static final String TOTAL_DELETION_FILES_KEY = "total_deletion_files";
    private static final String TOTAL_DATA_FILE_ROWS_KEY = "total_data_file_rows";
    private static final String TOTAL_DELETION_FILE_ROWS_KEY = "total_deletion_file_rows";
    private static final String TOTAL_ROWS_KEY = "total_rows";
    private final long totalFragments;
    private final long totalDataFiles;
    private final long totalFilesSize;
    private final long totalDeletionFiles;
    private final long totalDataFileRows;
    private final long totalDeletionFileRows;
    private final long totalRows;

    public ManifestSummary(long totalFragments, long totalDataFiles, long totalFilesSize, long totalDeletionFiles, long totalDataFileRows, long totalDeletionFileRows, long totalRows) {
        this.totalFragments = totalFragments;
        this.totalDataFiles = totalDataFiles;
        this.totalFilesSize = totalFilesSize;
        this.totalDeletionFiles = totalDeletionFiles;
        this.totalDataFileRows = totalDataFileRows;
        this.totalDeletionFileRows = totalDeletionFileRows;
        this.totalRows = totalRows;
    }

    public long getTotalDataFileRows() {
        return this.totalDataFileRows;
    }

    public long getTotalDataFiles() {
        return this.totalDataFiles;
    }

    public long getTotalDeletionFileRows() {
        return this.totalDeletionFileRows;
    }

    public long getTotalDeletionFiles() {
        return this.totalDeletionFiles;
    }

    public long getTotalFilesSize() {
        return this.totalFilesSize;
    }

    public long getTotalFragments() {
        return this.totalFragments;
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public static ManifestSummary fromMetadata(Map<String, String> map) {
        long totalFragments = Long.parseLong(map.getOrDefault(TOTAL_FRAGMENTS_KEY, "0"));
        long totalDataFiles = Long.parseLong(map.getOrDefault(TOTAL_DATA_FILES_KEY, "0"));
        long totalFilesSize = Long.parseLong(map.getOrDefault(TOTAL_FILES_SIZE_KEY, "0"));
        long totalDeletionFiles = Long.parseLong(map.getOrDefault(TOTAL_DELETION_FILES_KEY, "0"));
        long totalDataFileRows = Long.parseLong(map.getOrDefault(TOTAL_DATA_FILE_ROWS_KEY, "0"));
        long totalDeletionFileRows = Long.parseLong(map.getOrDefault(TOTAL_DELETION_FILE_ROWS_KEY, "0"));
        long totalRows = Long.parseLong(map.getOrDefault(TOTAL_ROWS_KEY, "0"));
        return new ManifestSummary(totalFragments, totalDataFiles, totalFilesSize, totalDeletionFiles, totalDataFileRows, totalDeletionFileRows, totalRows);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("totalFragments", this.totalFragments).add("totalDataFiles", this.totalDataFiles).add("totalFilesSize", this.totalFilesSize).add("totalDeletionFiles", this.totalDeletionFiles).add("totalDataFileRows", this.totalDataFileRows).add("totalDeletionFileRows", this.totalDeletionFileRows).add("totalRows", this.totalRows).toString();
    }
}

