/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.FloatShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortFloatMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.FloatShortPair;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.factory.primitive.FloatShortMaps;
import org.eclipse.collections.impl.factory.primitive.ShortBags;
import org.eclipse.collections.impl.factory.primitive.ShortFloatMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.FloatShortHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableFloatShortSingletonMap
implements ImmutableFloatShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_VALUE = 0;
    private final float key1;
    private final short value1;

    ImmutableFloatShortSingletonMap(float key1, short value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public short get(float key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getIfAbsent(float key, short ifAbsent) {
        return Float.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    public short getOrThrow(float key) {
        if (Float.compare(this.key1, key) == 0) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key) {
        return Float.compare(this.key1, key) == 0;
    }

    public boolean containsValue(short value) {
        return this.value1 == value;
    }

    public void forEachValue(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(FloatProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(FloatShortProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyFloatIterable keysView() {
        return FloatLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<FloatShortPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableShortFloatMap flipUniqueValues() {
        return ShortFloatMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableFloatShortMap select(FloatShortPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? FloatShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new FloatShortHashMap().toImmutable();
    }

    public ImmutableFloatShortMap reject(FloatShortPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new FloatShortHashMap().toImmutable() : FloatShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with((Object[])new ShortIterable[]{ShortBags.immutable.with(this.value1)});
    }

    public ImmutableFloatShortMap toImmutable() {
        return this;
    }

    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)FloatShortHashMap.newWithKeysValues(this.key1, this.value1).shortIterator());
    }

    public void each(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public short min() {
        return this.value1;
    }

    public short max() {
        return this.value1;
    }

    public short maxIfEmpty(short defaultValue) {
        return this.value1;
    }

    public short minIfEmpty(short defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public short[] toSortedArray() {
        return new short[]{this.value1};
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableShortBag select(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? ShortHashBag.newBagWith(this.value1).toImmutable() : ShortBags.immutable.empty();
    }

    public ImmutableShortBag reject(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? ShortBags.immutable.empty() : ShortHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public short[] toArray() {
        return new short[]{this.value1};
    }

    public short[] toArray(short[] target) {
        if (target.length < 1) {
            target = new short[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(short value) {
        return this.value1 == value;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableShortList toList() {
        return ShortArrayList.newListWith(this.value1);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSetWith(this.value1);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBagWith(this.value1);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public ImmutableFloatShortMap newWithKeyValue(float key, short value) {
        return FloatShortMaps.immutable.withAll((FloatShortMap)FloatShortHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableFloatShortMap newWithoutKey(float key) {
        return Float.compare(this.key1, key) == 0 ? FloatShortMaps.immutable.with() : this;
    }

    public ImmutableFloatShortMap newWithoutAllKeys(FloatIterable keys) {
        return keys.contains(this.key1) ? FloatShortMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(FloatHashSet.newSetWith(this.key1));
    }

    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of((MutableShortCollection)ShortArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatShortMap)) {
            return false;
        }
        FloatShortMap map = (FloatShortMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.key1) ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

