/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.system;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.util.Map;

public class AssertFunction
extends AbstractFunction {
    private static final long serialVersionUID = -1089556474491684233L;

    @Override
    public String getName() {
        return "assert";
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        boolean result = (Boolean)arg1.getValue(env);
        if (!result) {
            throw new AssertFailed();
        }
        return AviatorNil.NIL;
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        boolean result = (Boolean)arg1.getValue(env);
        if (!result) {
            throw new AssertFailed(FunctionUtils.getStringValue(arg2, env));
        }
        return AviatorNil.NIL;
    }

    public static final class AssertFailed
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AssertFailed() {
        }

        public AssertFailed(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public AssertFailed(String message, Throwable cause) {
            super(message, cause);
        }

        public AssertFailed(String message) {
            super(message);
        }

        public AssertFailed(Throwable cause) {
            super(cause);
        }
    }
}

