/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cache.EntityCache;
import org.apache.gravitino.meta.EntityIdResolver;
import org.apache.gravitino.meta.NamespacedEntityId;
import org.apache.gravitino.utils.NameIdentifierUtil;

public class CachedEntityIdResolver
implements EntityIdResolver {
    private final EntityCache entityCache;
    private final EntityIdResolver underlyingResolver;

    public CachedEntityIdResolver(EntityCache entityCache, EntityIdResolver underlyingResolver) {
        this.entityCache = entityCache;
        this.underlyingResolver = underlyingResolver;
    }

    @Override
    public NamespacedEntityId getEntityIds(NameIdentifier nameIdentifier, Entity.EntityType type) {
        return this.entityCache.getIfPresent(nameIdentifier, type).map(entity -> {
            if (nameIdentifier.hasNamespace()) {
                NamespacedEntityId namespaceIds = this.getEntityIds(NameIdentifierUtil.parentNameIdentifier(nameIdentifier, type), NameIdentifierUtil.parentEntityType(type));
                return new NamespacedEntityId(((HasIdentifier)((Object)entity)).id(), namespaceIds.fullIds());
            }
            return new NamespacedEntityId(((HasIdentifier)((Object)entity)).id());
        }).orElseGet(() -> this.underlyingResolver.getEntityIds(nameIdentifier, type));
    }

    @Override
    public Long getEntityId(NameIdentifier nameIdentifier, Entity.EntityType type) {
        return this.entityCache.getIfPresent(nameIdentifier, type).map(rec$ -> ((HasIdentifier)rec$).id()).orElseGet(() -> this.underlyingResolver.getEntityId(nameIdentifier, type));
    }
}

