/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.JobMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.JobPO;
import org.apache.ibatis.annotations.Param;

public class JobMetaPostgreSQLProvider
extends JobMetaBaseSQLProvider {
    @Override
    public String insertJobMetaOnDuplicateKeyUpdate(@Param(value="jobMeta") JobPO jobPO) {
        return "INSERT INTO job_run_meta (job_run_id, job_template_id, metalake_id, job_execution_id, job_run_status, job_finished_at, audit_info, current_version, last_version, deleted_at) VALUES (#{jobMeta.jobRunId}, (SELECT job_template_id FROM job_template_meta WHERE job_template_name = #{jobMeta.jobTemplateName} AND metalake_id = #{jobMeta.metalakeId} AND deleted_at = 0), #{jobMeta.metalakeId}, #{jobMeta.jobExecutionId}, #{jobMeta.jobRunStatus}, #{jobMeta.jobFinishedAt}, #{jobMeta.auditInfo}, #{jobMeta.currentVersion}, #{jobMeta.lastVersion}, #{jobMeta.deletedAt}) ON CONFLICT (job_run_id) DO UPDATE SET job_template_id = (SELECT job_template_id FROM job_template_meta WHERE job_template_name = #{jobMeta.jobTemplateName} AND metalake_id = #{jobMeta.metalakeId} AND deleted_at = 0), metalake_id = #{jobMeta.metalakeId}, job_execution_id = #{jobMeta.jobExecutionId}, job_run_status = #{jobMeta.jobRunStatus}, job_finished_at = #{jobMeta.jobFinishedAt}, audit_info = #{jobMeta.auditInfo}, current_version = #{jobMeta.currentVersion}, last_version = #{jobMeta.lastVersion}, deleted_at = #{jobMeta.deletedAt}";
    }

    @Override
    public String softDeleteJobMetaByMetalakeAndTemplate(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return "UPDATE job_run_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id IN ( SELECT metalake_id FROM metalake_meta WHERE metalake_name = #{metalakeName} AND deleted_at = 0) AND job_template_id IN ( SELECT job_template_id FROM job_template_meta WHERE job_template_name = #{jobTemplateName} AND deleted_at = 0) AND deleted_at = 0";
    }

    @Override
    public String softDeleteJobMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE job_run_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteJobMetaByRunId(@Param(value="jobRunId") Long jobRunId) {
        return "UPDATE job_run_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE job_run_id = #{jobRunId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteJobMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline) {
        return "UPDATE job_run_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE job_finished_at < #{legacyTimeline} AND job_finished_at > 0 AND deleted_at = 0";
    }

    @Override
    public String deleteJobMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM job_run_meta WHERE job_run_id IN (SELECT job_run_id FROM job_run_meta WHERE deleted_at < #{legacyTimeline} AND deleted_at > 0 LIMIT #{limit})";
    }
}

