/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.exceptions.InUseException;
import org.apache.gravitino.exceptions.JobTemplateAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchJobException;
import org.apache.gravitino.exceptions.NoSuchJobTemplateException;
import org.apache.gravitino.job.JobOperationDispatcher;
import org.apache.gravitino.job.JobTemplateChange;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.job.AlterJobTemplateEvent;
import org.apache.gravitino.listener.api.event.job.AlterJobTemplateFailureEvent;
import org.apache.gravitino.listener.api.event.job.AlterJobTemplatePreEvent;
import org.apache.gravitino.listener.api.event.job.CancelJobEvent;
import org.apache.gravitino.listener.api.event.job.CancelJobFailureEvent;
import org.apache.gravitino.listener.api.event.job.CancelJobPreEvent;
import org.apache.gravitino.listener.api.event.job.DeleteJobTemplateEvent;
import org.apache.gravitino.listener.api.event.job.DeleteJobTemplateFailureEvent;
import org.apache.gravitino.listener.api.event.job.DeleteJobTemplatePreEvent;
import org.apache.gravitino.listener.api.event.job.GetJobEvent;
import org.apache.gravitino.listener.api.event.job.GetJobFailureEvent;
import org.apache.gravitino.listener.api.event.job.GetJobPreEvent;
import org.apache.gravitino.listener.api.event.job.GetJobTemplateEvent;
import org.apache.gravitino.listener.api.event.job.GetJobTemplateFailureEvent;
import org.apache.gravitino.listener.api.event.job.GetJobTemplatePreEvent;
import org.apache.gravitino.listener.api.event.job.ListJobTemplatesEvent;
import org.apache.gravitino.listener.api.event.job.ListJobTemplatesFailureEvent;
import org.apache.gravitino.listener.api.event.job.ListJobTemplatesPreEvent;
import org.apache.gravitino.listener.api.event.job.ListJobsEvent;
import org.apache.gravitino.listener.api.event.job.ListJobsFailureEvent;
import org.apache.gravitino.listener.api.event.job.ListJobsPreEvent;
import org.apache.gravitino.listener.api.event.job.RegisterJobTemplateEvent;
import org.apache.gravitino.listener.api.event.job.RegisterJobTemplateFailureEvent;
import org.apache.gravitino.listener.api.event.job.RegisterJobTemplatePreEvent;
import org.apache.gravitino.listener.api.event.job.RunJobEvent;
import org.apache.gravitino.listener.api.event.job.RunJobFailureEvent;
import org.apache.gravitino.listener.api.event.job.RunJobPreEvent;
import org.apache.gravitino.listener.api.info.JobInfo;
import org.apache.gravitino.meta.JobEntity;
import org.apache.gravitino.meta.JobTemplateEntity;
import org.apache.gravitino.utils.PrincipalUtils;

public class JobEventDispatcher
implements JobOperationDispatcher {
    private final EventBus eventBus;
    private final JobOperationDispatcher jobOperationDispatcher;

    public JobEventDispatcher(EventBus eventBus, JobOperationDispatcher jobOperationDispatcher) {
        this.eventBus = eventBus;
        this.jobOperationDispatcher = jobOperationDispatcher;
    }

    @Override
    public List<JobTemplateEntity> listJobTemplates(String metalake) {
        this.eventBus.dispatchEvent(new ListJobTemplatesPreEvent(PrincipalUtils.getCurrentUserName(), metalake));
        try {
            List<JobTemplateEntity> jobTemplates = this.jobOperationDispatcher.listJobTemplates(metalake);
            this.eventBus.dispatchEvent(new ListJobTemplatesEvent(PrincipalUtils.getCurrentUserName(), metalake));
            return jobTemplates;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListJobTemplatesFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, e));
            throw e;
        }
    }

    @Override
    public void registerJobTemplate(String metalake, JobTemplateEntity jobTemplateEntity) throws JobTemplateAlreadyExistsException {
        this.eventBus.dispatchEvent(new RegisterJobTemplatePreEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateEntity.toJobTemplate()));
        try {
            this.jobOperationDispatcher.registerJobTemplate(metalake, jobTemplateEntity);
            this.eventBus.dispatchEvent(new RegisterJobTemplateEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateEntity.toJobTemplate()));
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new RegisterJobTemplateFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateEntity.toJobTemplate(), e));
            throw e;
        }
    }

    @Override
    public JobTemplateEntity getJobTemplate(String metalake, String jobTemplateName) throws NoSuchJobTemplateException {
        this.eventBus.dispatchEvent(new GetJobTemplatePreEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName));
        try {
            JobTemplateEntity jobTemplate = this.jobOperationDispatcher.getJobTemplate(metalake, jobTemplateName);
            this.eventBus.dispatchEvent(new GetJobTemplateEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplate.toJobTemplate()));
            return jobTemplate;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetJobTemplateFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName, e));
            throw e;
        }
    }

    @Override
    public boolean deleteJobTemplate(String metalake, String jobTemplateName) throws InUseException {
        this.eventBus.dispatchEvent(new DeleteJobTemplatePreEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName));
        try {
            boolean result = this.jobOperationDispatcher.deleteJobTemplate(metalake, jobTemplateName);
            this.eventBus.dispatchEvent(new DeleteJobTemplateEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName, result));
            return result;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DeleteJobTemplateFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName, e));
            throw e;
        }
    }

    @Override
    public JobTemplateEntity alterJobTemplate(String metalake, String jobTemplateName, JobTemplateChange ... changes) throws NoSuchJobTemplateException, IllegalArgumentException {
        this.eventBus.dispatchEvent(new AlterJobTemplatePreEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName, changes));
        try {
            JobTemplateEntity updatedJobTemplate = this.jobOperationDispatcher.alterJobTemplate(metalake, jobTemplateName, changes);
            this.eventBus.dispatchEvent(new AlterJobTemplateEvent(PrincipalUtils.getCurrentUserName(), metalake, changes, updatedJobTemplate.toJobTemplate()));
            return updatedJobTemplate;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterJobTemplateFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName, changes, e));
            throw e;
        }
    }

    @Override
    public List<JobEntity> listJobs(String metalake, Optional<String> jobTemplateName) throws NoSuchJobTemplateException {
        this.eventBus.dispatchEvent(new ListJobsPreEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName));
        try {
            List<JobEntity> jobs = this.jobOperationDispatcher.listJobs(metalake, jobTemplateName);
            this.eventBus.dispatchEvent(new ListJobsEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName));
            return jobs;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListJobsFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName, e));
            throw e;
        }
    }

    @Override
    public JobEntity getJob(String metalake, String jobId) throws NoSuchJobException {
        this.eventBus.dispatchEvent(new GetJobPreEvent(PrincipalUtils.getCurrentUserName(), metalake, jobId));
        try {
            JobEntity job = this.jobOperationDispatcher.getJob(metalake, jobId);
            this.eventBus.dispatchEvent(new GetJobEvent(PrincipalUtils.getCurrentUserName(), metalake, JobInfo.fromJobEntity(job)));
            return job;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetJobFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, jobId, e));
            throw e;
        }
    }

    @Override
    public JobEntity runJob(String metalake, String jobTemplateName, Map<String, String> jobConf) throws NoSuchJobTemplateException {
        this.eventBus.dispatchEvent(new RunJobPreEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName, jobConf));
        try {
            JobEntity job = this.jobOperationDispatcher.runJob(metalake, jobTemplateName, jobConf);
            this.eventBus.dispatchEvent(new RunJobEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName, jobConf, JobInfo.fromJobEntity(job)));
            return job;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new RunJobFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, jobTemplateName, jobConf, e));
            throw e;
        }
    }

    @Override
    public JobEntity cancelJob(String metalake, String jobId) throws NoSuchJobException {
        this.eventBus.dispatchEvent(new CancelJobPreEvent(PrincipalUtils.getCurrentUserName(), metalake, jobId));
        try {
            JobEntity job = this.jobOperationDispatcher.cancelJob(metalake, jobId);
            this.eventBus.dispatchEvent(new CancelJobEvent(PrincipalUtils.getCurrentUserName(), metalake, JobInfo.fromJobEntity(job)));
            return job;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new CancelJobFailureEvent(PrincipalUtils.getCurrentUserName(), metalake, jobId, e));
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.jobOperationDispatcher != null) {
            this.jobOperationDispatcher.close();
        }
    }
}

