/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.messaging;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTopicException;
import org.apache.gravitino.exceptions.TopicAlreadyExistsException;
import org.apache.gravitino.messaging.DataLayout;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.messaging.TopicChange;

@Evolving
public interface TopicCatalog {
    public NameIdentifier[] listTopics(Namespace var1) throws NoSuchSchemaException;

    public Topic loadTopic(NameIdentifier var1) throws NoSuchTopicException;

    default public boolean topicExists(NameIdentifier ident) {
        try {
            this.loadTopic(ident);
            return true;
        }
        catch (NoSuchTopicException e) {
            return false;
        }
    }

    public Topic createTopic(NameIdentifier var1, String var2, DataLayout var3, Map<String, String> var4) throws NoSuchSchemaException, TopicAlreadyExistsException;

    public Topic alterTopic(NameIdentifier var1, TopicChange ... var2) throws NoSuchTopicException, IllegalArgumentException;

    public boolean dropTopic(NameIdentifier var1);
}

