/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.oss.credential.policy;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.gravitino.oss.credential.policy.Statement;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Policy {
    @JsonProperty(value="Version")
    private String version;
    @JsonProperty(value="Statement")
    private List<Statement> statements;

    private Policy(Builder builder) {
        this.version = builder.version;
        this.statements = builder.statements;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVersion() {
        return this.version;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public static class Builder {
        private String version;
        private List<Statement> statements = new ArrayList<Statement>();

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder addStatement(Statement statement) {
            this.statements.add(statement);
            return this;
        }

        public Policy build() {
            return new Policy(this);
        }
    }
}

