/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.json.JsonUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.StatisticEntity;
import org.apache.gravitino.stats.StatisticValue;

public class StatisticPO {
    private Long metalakeId;
    private Long statisticId;
    private String statisticName;
    private String statisticValue;
    private Long metadataObjectId;
    private String metadataObjectType;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    private StatisticPO() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StatisticEntity fromStatisticPO(StatisticPO statisticPO) {
        try {
            return ((StatisticEntity.StatisticEntityBuilder)((StatisticEntity.StatisticEntityBuilder)((StatisticEntity.StatisticEntityBuilder)((StatisticEntity.StatisticEntityBuilder)((StatisticEntity.StatisticEntityBuilder)StatisticEntity.builder(StatisticEntity.getStatisticType(MetadataObject.Type.valueOf((String)statisticPO.metadataObjectType)))).withId(statisticPO.getStatisticId())).withName(statisticPO.getStatisticName())).withValue((StatisticValue)JsonUtils.anyFieldMapper().readValue(statisticPO.getStatisticValue(), StatisticValue.class))).withAuditInfo((AuditInfo)JsonUtils.anyFieldMapper().readValue(statisticPO.getAuditInfo(), AuditInfo.class))).build();
        }
        catch (JsonProcessingException je) {
            throw new RuntimeException("Failed to deserialize json object: ", je);
        }
    }

    public static List<StatisticPO> initializeStatisticPOs(List<StatisticEntity> statisticEntities, Long metalakeId, Long objectId, MetadataObject.Type objectType) {
        return statisticEntities.stream().map(statisticEntity -> {
            try {
                return StatisticPO.builder().withMetalakeId(metalakeId).withMetadataObjectId(objectId).withMetadataObjectType(objectType.name()).withStatisticId(statisticEntity.id()).withStatisticName(statisticEntity.name()).withStatisticValue(JsonUtils.anyFieldMapper().writeValueAsString(statisticEntity.value())).withDeletedAt(0L).withCurrentVersion(1L).withLastVersion(1L).withAuditInfo(JsonUtils.anyFieldMapper().writeValueAsString((Object)statisticEntity.auditInfo())).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to serialize json object:", e);
            }
        }).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatisticPO)) {
            return false;
        }
        StatisticPO that = (StatisticPO)o;
        return this.statisticId.equals(that.statisticId) && this.metadataObjectId.equals(that.metadataObjectId) && this.metalakeId.equals(that.metalakeId) && this.metadataObjectType.equals(that.metadataObjectType) && this.statisticName.equals(that.statisticName) && this.statisticValue.equals(that.statisticValue) && this.auditInfo.equals(that.auditInfo) && this.currentVersion.equals(that.currentVersion) && this.lastVersion.equals(that.lastVersion) && this.deletedAt.equals(that.deletedAt);
    }

    public int hashCode() {
        return Objects.hash(this.metalakeId, this.statisticId, this.metadataObjectId, this.metadataObjectType, this.statisticName, this.statisticValue, this.auditInfo, this.currentVersion, this.lastVersion, this.deletedAt);
    }

    public Long getMetalakeId() {
        return this.metalakeId;
    }

    public Long getStatisticId() {
        return this.statisticId;
    }

    public String getStatisticName() {
        return this.statisticName;
    }

    public String getStatisticValue() {
        return this.statisticValue;
    }

    public Long getMetadataObjectId() {
        return this.metadataObjectId;
    }

    public String getMetadataObjectType() {
        return this.metadataObjectType;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public static class Builder {
        private final StatisticPO statisticPO = new StatisticPO();

        public Builder withMetalakeId(Long metalakeId) {
            this.statisticPO.metalakeId = metalakeId;
            return this;
        }

        public Builder withStatisticId(Long statisticId) {
            this.statisticPO.statisticId = statisticId;
            return this;
        }

        public Builder withMetadataObjectId(Long objectId) {
            this.statisticPO.metadataObjectId = objectId;
            return this;
        }

        public Builder withMetadataObjectType(String objectType) {
            this.statisticPO.metadataObjectType = objectType;
            return this;
        }

        public Builder withStatisticName(String statisticName) {
            this.statisticPO.statisticName = statisticName;
            return this;
        }

        public Builder withStatisticValue(String value) {
            this.statisticPO.statisticValue = value;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.statisticPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.statisticPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.statisticPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.statisticPO.deletedAt = deletedAt;
            return this;
        }

        public StatisticPO build() {
            Preconditions.checkArgument((this.statisticPO.metadataObjectId != null ? 1 : 0) != 0, (Object)"`objectId is required");
            Preconditions.checkArgument((this.statisticPO.metadataObjectType != null ? 1 : 0) != 0, (Object)"`objectType` is required");
            Preconditions.checkArgument((this.statisticPO.statisticId != null ? 1 : 0) != 0, (Object)"`statisticId` is required");
            Preconditions.checkArgument((this.statisticPO.statisticName != null ? 1 : 0) != 0, (Object)"`statisticName` is required");
            Preconditions.checkArgument((this.statisticPO.statisticValue != null ? 1 : 0) != 0, (Object)"`value` is required");
            Preconditions.checkArgument((this.statisticPO.auditInfo != null ? 1 : 0) != 0, (Object)"`auditInfo` is required");
            Preconditions.checkArgument((this.statisticPO.metalakeId != null ? 1 : 0) != 0, (Object)"`metalakeId` is required");
            Preconditions.checkArgument((this.statisticPO.deletedAt != null ? 1 : 0) != 0, (Object)"`deletedAt` is required");
            Preconditions.checkArgument((this.statisticPO.lastVersion != null ? 1 : 0) != 0, (Object)"`lastVersion` is required");
            Preconditions.checkArgument((this.statisticPO.currentVersion != null ? 1 : 0) != 0, (Object)"`currentVersion` is required");
            return this.statisticPO;
        }
    }
}

