/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.ColumnEntity;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.gravitino.utils.CollectionUtils;

public class TableEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The table's unique identifier");
    public static final Field NAME = Field.required("name", String.class, "The table's name");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the table");
    public static final Field COLUMNS = Field.optional("columns", List.class, "The columns of the table");
    public static final Field FORMAT = Field.optional("format", String.class, "The table's format");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The table's properties");
    public static final Field PARTITIONING = Field.optional("partitioning", Transform[].class, "The table's partitioning");
    public static final Field SORT_ORDERS = Field.optional("sortOrders", SortOrder[].class, "The table's sort order");
    public static final Field DISTRIBUTION = Field.optional("distribution", Distribution.class, "The table's distribution");
    public static final Field INDEXES = Field.optional("indexes", Index[].class, "The table's indexes");
    public static final Field COMMENT = Field.optional("comment", String.class, "The table's comment");
    private Long id;
    private String name;
    private AuditInfo auditInfo;
    private Namespace namespace;
    private List<ColumnEntity> columns;
    private Map<String, String> properties;
    private Transform[] partitioning;
    private SortOrder[] sortOrders;
    private Distribution distribution;
    private Index[] indexes;
    private String comment;

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(AUDIT_INFO, this.auditInfo);
        fields.put(COLUMNS, this.columns);
        fields.put(PROPERTIES, this.properties);
        fields.put(PARTITIONING, this.partitioning);
        fields.put(SORT_ORDERS, this.sortOrders);
        fields.put(DISTRIBUTION, this.distribution);
        fields.put(INDEXES, this.indexes);
        fields.put(COMMENT, this.comment);
        return fields;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.TABLE;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public List<ColumnEntity> columns() {
        return this.columns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableEntity)) {
            return false;
        }
        TableEntity baseTable = (TableEntity)o;
        return Objects.equal((Object)this.id, (Object)baseTable.id) && Objects.equal((Object)this.name, (Object)baseTable.name) && Objects.equal((Object)this.namespace, (Object)baseTable.namespace) && Objects.equal((Object)this.auditInfo, (Object)baseTable.auditInfo) && CollectionUtils.isEqualCollection(this.columns, baseTable.columns) && Objects.equal(this.properties, baseTable.properties) && Arrays.equals(this.partitioning, baseTable.partitioning) && Arrays.equals(this.sortOrders, baseTable.sortOrders) && Objects.equal((Object)this.distribution, (Object)baseTable.distribution) && Arrays.equals(this.indexes, baseTable.indexes) && Objects.equal((Object)this.comment, (Object)baseTable.comment);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.auditInfo, this.columns, this.namespace, this.properties, Arrays.hashCode(this.partitioning), Arrays.hashCode(this.sortOrders), this.distribution, this.distribution, Arrays.hashCode(this.indexes), this.comment});
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "TableEntity(id=" + this.id + ", name=" + this.name + ", auditInfo=" + String.valueOf(this.auditInfo) + ", namespace=" + String.valueOf(this.namespace) + ", columns=" + String.valueOf(this.columns) + ", properties=" + String.valueOf(this.properties()) + ", partitioning=" + Arrays.deepToString(this.partitioning()) + ", sortOrders=" + Arrays.deepToString(this.sortOrders()) + ", distribution=" + String.valueOf(this.distribution()) + ", indexes=" + Arrays.deepToString(this.indexes()) + ", comment=" + this.comment() + ")";
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Transform[] partitioning() {
        return this.partitioning;
    }

    public SortOrder[] sortOrders() {
        return this.sortOrders;
    }

    public Distribution distribution() {
        return this.distribution;
    }

    public Index[] indexes() {
        return this.indexes;
    }

    public String comment() {
        return this.comment;
    }

    public static class Builder {
        private final TableEntity tableEntity = new TableEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.tableEntity.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.tableEntity.name = name;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.tableEntity.auditInfo = auditInfo;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.tableEntity.namespace = namespace;
            return this;
        }

        public Builder withColumns(List<ColumnEntity> columns) {
            this.tableEntity.columns = columns;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.tableEntity.properties = properties;
            return this;
        }

        public Builder withPartitioning(Transform[] partitioning) {
            this.tableEntity.partitioning = partitioning;
            return this;
        }

        public Builder withSortOrders(SortOrder[] sortOrders) {
            this.tableEntity.sortOrders = sortOrders;
            return this;
        }

        public Builder withDistribution(Distribution distribution) {
            this.tableEntity.distribution = distribution;
            return this;
        }

        public Builder withIndexes(Index[] indexes) {
            this.tableEntity.indexes = indexes;
            return this;
        }

        public Builder withComment(String comment) {
            this.tableEntity.comment = comment;
            return this;
        }

        public TableEntity build() {
            this.tableEntity.validate();
            this.tableEntity.columns = this.tableEntity.columns == null ? Collections.emptyList() : this.tableEntity.columns;
            this.tableEntity.properties = this.tableEntity.properties == null ? Collections.emptyMap() : this.tableEntity.properties;
            this.tableEntity.indexes = this.tableEntity.indexes == null ? Indexes.EMPTY_INDEXES : this.tableEntity.indexes;
            this.tableEntity.partitioning = this.tableEntity.partitioning == null ? Transforms.EMPTY_TRANSFORM : this.tableEntity.partitioning;
            this.tableEntity.sortOrders = this.tableEntity.sortOrders == null ? new SortOrder[]{} : this.tableEntity.sortOrders;
            this.tableEntity.distribution = this.tableEntity.distribution == null ? Distributions.NONE : this.tableEntity.distribution;
            return this.tableEntity;
        }
    }
}

