/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.listener.api.event.ModelPreEvent;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.info.Either;
import org.apache.gravitino.model.ModelVersionChange;

@DeveloperApi
public class AlterModelVersionPreEvent
extends ModelPreEvent {
    private final Either<String, Integer> aliasOrVersion;
    private ModelVersionChange[] modelVersionChanges;

    public AlterModelVersionPreEvent(String user, NameIdentifier identifier, Either<String, Integer> aliasOrVersion, ModelVersionChange[] modelVersionChanges) {
        super(user, identifier);
        this.aliasOrVersion = aliasOrVersion;
        this.modelVersionChanges = modelVersionChanges;
    }

    public String alias() {
        return this.aliasOrVersion.left().orElseThrow(() -> new IllegalStateException("Alias can't be null value"));
    }

    public Integer version() {
        return this.aliasOrVersion.right().orElseThrow(() -> new IllegalStateException("Version can't be null value"));
    }

    public ModelVersionChange[] modelVersionChanges() {
        return this.modelVersionChanges;
    }

    @Override
    public OperationType operationType() {
        return OperationType.ALTER_MODEL_VERSION;
    }
}

