/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.authorization;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.dto.authorization.PrivilegeDTO;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class SecurableObjectDTO
implements SecurableObject {
    @JsonProperty(value="type")
    private MetadataObject.Type type;
    @JsonProperty(value="privileges")
    private PrivilegeDTO[] privileges;
    private String parent;
    private String name;

    protected SecurableObjectDTO() {
    }

    @JsonProperty(value="fullName")
    public String getFullName() {
        return this.fullName();
    }

    @JsonProperty(value="fullName")
    public void setFullName(String fullName) {
        int index = fullName.lastIndexOf(".");
        if (index == -1) {
            this.parent = null;
            this.name = fullName;
        } else {
            this.parent = fullName.substring(0, index);
            this.name = fullName.substring(index + 1);
        }
    }

    @Override
    @Nullable
    public String parent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public MetadataObject.Type type() {
        return this.type;
    }

    @Override
    public List<Privilege> privileges() {
        if (this.privileges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.privileges));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final SecurableObjectDTO securableObjectDTO = new SecurableObjectDTO();
        private String fullName;
        private MetadataObject.Type type;
        private PrivilegeDTO[] privileges;

        private Builder() {
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder withType(MetadataObject.Type type) {
            this.type = type;
            return this;
        }

        public Builder withPrivileges(PrivilegeDTO[] privileges) {
            this.privileges = privileges;
            return this;
        }

        public SecurableObjectDTO build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.fullName), "full name cannot be null or empty");
            Preconditions.checkArgument(this.type != null, "type cannot be null");
            Preconditions.checkArgument(this.privileges != null && this.privileges.length != 0, "privileges can't be null or empty");
            this.securableObjectDTO.type = this.type;
            this.securableObjectDTO.privileges = this.privileges;
            this.securableObjectDTO.setFullName(this.fullName);
            return this.securableObjectDTO;
        }
    }
}

