/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import java.util.Map;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableMap;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class AwsIrsaCredential
implements Credential {
    public static final String AWS_IRSA_CREDENTIAL_TYPE = "aws-irsa";
    public static final String ACCESS_KEY_ID = "access-key-id";
    public static final String SECRET_ACCESS_KEY = "secret-access-key";
    public static final String SESSION_TOKEN = "session-token";
    private String accessKeyId;
    private String secretAccessKey;
    private String sessionToken;
    private long expireTimeInMs;

    public AwsIrsaCredential(String accessKeyId, String secretAccessKey, String sessionToken, long expireTimeInMs) {
        this.validate(accessKeyId, secretAccessKey, sessionToken);
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.expireTimeInMs = expireTimeInMs;
    }

    public AwsIrsaCredential() {
    }

    @Override
    public String credentialType() {
        return AWS_IRSA_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return this.expireTimeInMs;
    }

    @Override
    public Map<String, String> credentialInfo() {
        ImmutableMap.Builder<String, String> builder = new ImmutableMap.Builder<String, String>();
        builder.put(ACCESS_KEY_ID, this.accessKeyId);
        builder.put(SECRET_ACCESS_KEY, this.secretAccessKey);
        builder.put(SESSION_TOKEN, this.sessionToken);
        return builder.build();
    }

    @Override
    public void initialize(Map<String, String> credentialInfo, long expireTimeInMs) {
        String accessKeyId = credentialInfo.get(ACCESS_KEY_ID);
        String secretAccessKey = credentialInfo.get(SECRET_ACCESS_KEY);
        String sessionToken = credentialInfo.get(SESSION_TOKEN);
        this.validate(accessKeyId, secretAccessKey, sessionToken);
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.expireTimeInMs = expireTimeInMs;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    private void validate(String accessKeyId, String secretAccessKey, String sessionToken) {
        Preconditions.checkArgument(StringUtils.isNotBlank(accessKeyId), "Access key Id should not be empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(secretAccessKey), "Secret access key should not be empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(sessionToken), "Session token should not be empty");
    }
}

