/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.GroupRoleRelMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.RoleMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.UserRoleRelMapper;
import org.apache.gravitino.storage.relational.po.RolePO;
import org.apache.gravitino.storage.relational.po.SecurableObjectPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.service.MetadataObjectService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.UserMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleMetaService {
    private static final Logger LOG;
    private static final RoleMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ Annotation ajc$anno$8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ Annotation ajc$anno$9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ Annotation ajc$anno$10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ Annotation ajc$anno$11;

    public static RoleMetaService getInstance() {
        return INSTANCE;
    }

    private RoleMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getRoleIdByMetalakeIdAndName")
    public Long getRoleIdByMetalakeIdAndName(Long metalakeId, String roleName) {
        Long l = metalakeId;
        String string = roleName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = RoleMetaService.class.getDeclaredMethod("getRoleIdByMetalakeIdAndName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (Long)RoleMetaService.getRoleIdByMetalakeIdAndName_aroundBody1$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listRolesByUserId")
    public List<RolePO> listRolesByUserId(Long userId) {
        Long l = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)l);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = RoleMetaService.class.getDeclaredMethod("listRolesByUserId", Long.class).getAnnotation(Monitored.class);
        }
        return (List)RoleMetaService.listRolesByUserId_aroundBody3$advice(this, l, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listRolesByUserIdent")
    public List<RoleEntity> listRolesByUserIdent(NameIdentifier userIdent) {
        NameIdentifier nameIdentifier = userIdent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = RoleMetaService.class.getDeclaredMethod("listRolesByUserIdent", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (List)RoleMetaService.listRolesByUserIdent_aroundBody5$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listRolesByMetadataObject")
    public List<RoleEntity> listRolesByMetadataObject(NameIdentifier metadataObjectIdent, Entity.EntityType metadataObjectType, boolean allFields) {
        NameIdentifier nameIdentifier = metadataObjectIdent;
        Entity.EntityType entityType = metadataObjectType;
        boolean bl = allFields;
        Object[] objectArray = new Object[]{nameIdentifier, entityType, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = RoleMetaService.class.getDeclaredMethod("listRolesByMetadataObject", NameIdentifier.class, Entity.EntityType.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        return (List)RoleMetaService.listRolesByMetadataObject_aroundBody7$advice(this, nameIdentifier, entityType, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listRolesByGroupId")
    public List<RolePO> listRolesByGroupId(Long groupId) {
        Long l = groupId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)l);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = RoleMetaService.class.getDeclaredMethod("listRolesByGroupId", Long.class).getAnnotation(Monitored.class);
        }
        return (List)RoleMetaService.listRolesByGroupId_aroundBody9$advice(this, l, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertRole")
    public void insertRole(RoleEntity roleEntity, boolean overwritten) throws IOException {
        RoleEntity roleEntity2 = roleEntity;
        boolean bl = overwritten;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)roleEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = RoleMetaService.class.getDeclaredMethod("insertRole", RoleEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        RoleMetaService.insertRole_aroundBody11$advice(this, roleEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateRole")
    public <E extends Entity & HasIdentifier> RoleEntity updateRole(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = identifier;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = RoleMetaService.class.getDeclaredMethod("updateRole", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (RoleEntity)RoleMetaService.updateRole_aroundBody13$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    private List<SecurableObjectPO> toSecurableObjectPOs(Set<SecurableObject> deleteObjects, RoleEntity oldRoleEntity, String metalake) {
        ArrayList securableObjectPOs = Lists.newArrayList();
        for (SecurableObject object : deleteObjects) {
            SecurableObjectPO.Builder objectBuilder = POConverters.initializeSecurablePOBuilderWithVersion(oldRoleEntity.id(), object, RoleMetaService.getType(object));
            NameIdentifier nameIdentifier = MetadataObjectUtil.toEntityIdent(metalake, (MetadataObject)object);
            Entity.EntityType entityType = MetadataObjectUtil.toEntityType(object.type());
            objectBuilder.withMetadataObjectId(EntityIdService.getEntityId(nameIdentifier, entityType));
            securableObjectPOs.add(objectBuilder.build());
        }
        return securableObjectPOs;
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getRoleByIdentifier")
    public RoleEntity getRoleByIdentifier(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = RoleMetaService.class.getDeclaredMethod("getRoleByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (RoleEntity)RoleMetaService.getRoleByIdentifier_aroundBody15$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteRole")
    public boolean deleteRole(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$8;
        if (annotation == null) {
            annotation = ajc$anno$8 = RoleMetaService.class.getDeclaredMethod("deleteRole", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)RoleMetaService.deleteRole_aroundBody17$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listSecurableObjectsByRoleId")
    public static List<SecurableObjectPO> listSecurableObjectsByRoleId(Long roleId) {
        Long l = roleId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)l);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$9;
        if (annotation == null) {
            annotation = ajc$anno$9 = RoleMetaService.class.getDeclaredMethod("listSecurableObjectsByRoleId", Long.class).getAnnotation(Monitored.class);
        }
        return (List)RoleMetaService.listSecurableObjectsByRoleId_aroundBody19$advice(l, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listRolesByNamespace")
    public List<RoleEntity> listRolesByNamespace(Namespace namespace) {
        Namespace namespace2 = namespace;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)namespace2);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$10;
        if (annotation == null) {
            annotation = ajc$anno$10 = RoleMetaService.class.getDeclaredMethod("listRolesByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)RoleMetaService.listRolesByNamespace_aroundBody21$advice(this, namespace2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteRoleMetasByLegacyTimeline")
    public int deleteRoleMetasByLegacyTimeline(long legacyTimeline, int limit) {
        long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$11;
        if (annotation == null) {
            annotation = ajc$anno$11 = RoleMetaService.class.getDeclaredMethod("deleteRoleMetasByLegacyTimeline", Long.TYPE, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)RoleMetaService.deleteRoleMetasByLegacyTimeline_aroundBody23$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    private static List<SecurableObject> listSecurableObjects(RolePO po) {
        List<SecurableObjectPO> securableObjectPOs = RoleMetaService.listSecurableObjectsByRoleId(po.getRoleId());
        ArrayList securableObjects = Lists.newArrayList();
        securableObjectPOs.stream().collect(Collectors.groupingBy(SecurableObjectPO::getType)).forEach((type, objects) -> {
            List objectIds = objects.stream().map(SecurableObjectPO::getMetadataObjectId).collect(Collectors.toList());
            Map objectIdAndNameMap = Optional.of(MetadataObject.Type.valueOf((String)type)).map(MetadataObjectService.TYPE_TO_FULLNAME_FUNCTION_MAP::get).map(getter -> (Map)getter.apply(objectIds)).orElseThrow(() -> new IllegalArgumentException("Unsupported metadata object type: " + type));
            for (SecurableObjectPO securableObjectPO : objects) {
                String fullName = (String)objectIdAndNameMap.get(securableObjectPO.getMetadataObjectId());
                if (fullName != null) {
                    securableObjects.add(POConverters.fromSecurableObjectPO(fullName, securableObjectPO, RoleMetaService.getType(securableObjectPO.getType())));
                    continue;
                }
                LOG.warn("The securable object {} {} may be deleted", (Object)securableObjectPO.getMetadataObjectId(), (Object)securableObjectPO.getType());
            }
        });
        return securableObjects;
    }

    private static RolePO getRolePOByMetalakeIdAndName(Long metalakeId, String roleName) {
        RolePO rolePO = SessionUtils.getWithoutCommit(RoleMetaMapper.class, mapper -> mapper.selectRoleMetaByMetalakeIdAndName(metalakeId, roleName));
        if (rolePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.ROLE.name().toLowerCase(), roleName});
        }
        return rolePO;
    }

    private static MetadataObject.Type getType(String type) {
        return MetadataObject.Type.valueOf((String)type);
    }

    private static String getType(SecurableObject securableObject) {
        return securableObject.type().name();
    }

    static {
        RoleMetaService.ajc$preClinit();
        LOG = LoggerFactory.getLogger(RoleMetaService.class);
        INSTANCE = new RoleMetaService();
    }

    private static final /* synthetic */ Long getRoleIdByMetalakeIdAndName_aroundBody0(RoleMetaService ajc$this, Long metalakeId, String roleName, JoinPoint joinPoint) {
        Long roleId = SessionUtils.getWithoutCommit(RoleMetaMapper.class, mapper -> mapper.selectRoleIdByMetalakeIdAndName(metalakeId, roleName));
        if (roleId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.ROLE.name().toLowerCase(), roleName});
        }
        return roleId;
    }

    private static final /* synthetic */ Object getRoleIdByMetalakeIdAndName_aroundBody1$advice(RoleMetaService ajc$this, Long metalakeId, String roleName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Long l;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.getRoleIdByMetalakeIdAndName_aroundBody0(ajc$this, metalakeId, roleName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.getRoleIdByMetalakeIdAndName_aroundBody0(ajc$this, metalakeId, roleName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Long result = RoleMetaService.getRoleIdByMetalakeIdAndName_aroundBody0(ajc$this, metalakeId, roleName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                l = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return l;
    }

    private static final /* synthetic */ List listRolesByUserId_aroundBody2(RoleMetaService ajc$this, Long userId, JoinPoint joinPoint) {
        return SessionUtils.getWithoutCommit(RoleMetaMapper.class, mapper -> mapper.listRolesByUserId(userId));
    }

    private static final /* synthetic */ Object listRolesByUserId_aroundBody3$advice(RoleMetaService ajc$this, Long userId, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByUserId_aroundBody2(ajc$this, userId, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByUserId_aroundBody2(ajc$this, userId, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = RoleMetaService.listRolesByUserId_aroundBody2(ajc$this, userId, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ List listRolesByUserIdent_aroundBody4(RoleMetaService ajc$this, NameIdentifier userIdent, JoinPoint joinPoint) {
        UserEntity user = UserMetaService.getInstance().getUserByIdentifier(userIdent);
        String metalake = NameIdentifierUtil.getMetalake(userIdent);
        List<RolePO> rolePOs = ajc$this.listRolesByUserId(user.id());
        return rolePOs.stream().map(po -> POConverters.fromRolePO(po, Collections.emptyList(), AuthorizationUtils.ofRoleNamespace(metalake))).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listRolesByUserIdent_aroundBody5$advice(RoleMetaService ajc$this, NameIdentifier userIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByUserIdent_aroundBody4(ajc$this, userIdent, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByUserIdent_aroundBody4(ajc$this, userIdent, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = RoleMetaService.listRolesByUserIdent_aroundBody4(ajc$this, userIdent, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ List listRolesByMetadataObject_aroundBody6(RoleMetaService ajc$this, NameIdentifier metadataObjectIdent, Entity.EntityType metadataObjectType, boolean allFields, JoinPoint joinPoint) {
        String metalake = NameIdentifierUtil.getMetalake(metadataObjectIdent);
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(metadataObjectIdent, metadataObjectType);
        long metadataObjectId = EntityIdService.getEntityId(metadataObjectIdent, metadataObjectType);
        List rolePOs = SessionUtils.getWithoutCommit(RoleMetaMapper.class, mapper -> mapper.listRolesByMetadataObjectIdAndType(metadataObjectId, metadataObject.type().name()));
        return rolePOs.stream().map(po -> {
            if (allFields) {
                return POConverters.fromRolePO(po, RoleMetaService.listSecurableObjects(po), AuthorizationUtils.ofRoleNamespace(metalake));
            }
            return POConverters.fromRolePO(po, Collections.emptyList(), AuthorizationUtils.ofRoleNamespace(metalake));
        }).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listRolesByMetadataObject_aroundBody7$advice(RoleMetaService ajc$this, NameIdentifier metadataObjectIdent, Entity.EntityType metadataObjectType, boolean allFields, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByMetadataObject_aroundBody6(ajc$this, metadataObjectIdent, metadataObjectType, allFields, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByMetadataObject_aroundBody6(ajc$this, metadataObjectIdent, metadataObjectType, allFields, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = RoleMetaService.listRolesByMetadataObject_aroundBody6(ajc$this, metadataObjectIdent, metadataObjectType, allFields, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ List listRolesByGroupId_aroundBody8(RoleMetaService ajc$this, Long groupId, JoinPoint joinPoint) {
        return SessionUtils.getWithoutCommit(RoleMetaMapper.class, mapper -> mapper.listRolesByGroupId(groupId));
    }

    private static final /* synthetic */ Object listRolesByGroupId_aroundBody9$advice(RoleMetaService ajc$this, Long groupId, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByGroupId_aroundBody8(ajc$this, groupId, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByGroupId_aroundBody8(ajc$this, groupId, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = RoleMetaService.listRolesByGroupId_aroundBody8(ajc$this, groupId, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ void insertRole_aroundBody10(RoleMetaService ajc$this, RoleEntity roleEntity, boolean overwritten, JoinPoint joinPoint) {
        try {
            AuthorizationUtils.checkRole(roleEntity.nameIdentifier());
            String metalake = NameIdentifierUtil.getMetalake(roleEntity.nameIdentifier());
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalake);
            RolePO.Builder builder = RolePO.builder().withMetalakeId(metalakeId);
            RolePO rolePO = POConverters.initializeRolePOWithVersion(roleEntity, builder);
            ArrayList securableObjectPOs = Lists.newArrayList();
            for (SecurableObject object : roleEntity.securableObjects()) {
                SecurableObjectPO.Builder objectBuilder = POConverters.initializeSecurablePOBuilderWithVersion(roleEntity.id(), object, RoleMetaService.getType(object));
                NameIdentifier identifier = MetadataObjectUtil.toEntityIdent(metalake, (MetadataObject)object);
                Entity.EntityType entityType = MetadataObjectUtil.toEntityType(object.type());
                objectBuilder.withMetadataObjectId(EntityIdService.getEntityId(identifier, entityType));
                securableObjectPOs.add(objectBuilder.build());
            }
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> {
                if (overwritten) {
                    mapper.softDeleteSecurableObjectsByRoleId(rolePO.getRoleId());
                }
                if (!securableObjectPOs.isEmpty()) {
                    mapper.batchInsertSecurableObjects(securableObjectPOs);
                }
            }), () -> SessionUtils.doWithoutCommit(RoleMetaMapper.class, mapper -> {
                if (overwritten) {
                    mapper.insertRoleMetaOnDuplicateKeyUpdate(rolePO);
                } else {
                    mapper.insertRoleMeta(rolePO);
                }
            }));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.ROLE, roleEntity.nameIdentifier().toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object insertRole_aroundBody11$advice(RoleMetaService ajc$this, RoleEntity roleEntity, boolean overwritten, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                RoleMetaService.insertRole_aroundBody10(ajc$this, roleEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                RoleMetaService.insertRole_aroundBody10(ajc$this, roleEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                RoleMetaService.insertRole_aroundBody10(ajc$this, roleEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ RoleEntity updateRole_aroundBody12(RoleMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint joinPoint) {
        AuthorizationUtils.checkRole(identifier);
        try {
            String metalake = NameIdentifierUtil.getMetalake(identifier);
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalake);
            RolePO rolePO = RoleMetaService.getRolePOByMetalakeIdAndName(metalakeId, identifier.name());
            RoleEntity oldRoleEntity = POConverters.fromRolePO(rolePO, RoleMetaService.listSecurableObjects(rolePO), AuthorizationUtils.ofRoleNamespace(metalake));
            RoleEntity newRoleEntity = (RoleEntity)updater.apply(oldRoleEntity);
            Preconditions.checkArgument((boolean)Objects.equals(oldRoleEntity.id(), newRoleEntity.id()), (String)"The updated role entity id: %s should be same with the role entity id before: %s", (Object)newRoleEntity.id(), (Object)oldRoleEntity.id());
            HashSet<SecurableObject> oldObjects = new HashSet<SecurableObject>(oldRoleEntity.securableObjects());
            HashSet<SecurableObject> newObjects = new HashSet<SecurableObject>(newRoleEntity.securableObjects());
            Sets.SetView insertObjects = Sets.difference(newObjects, oldObjects);
            Sets.SetView deleteObjects = Sets.difference(oldObjects, newObjects);
            if (insertObjects.isEmpty() && deleteObjects.isEmpty()) {
                return newRoleEntity;
            }
            List<SecurableObjectPO> deleteSecurableObjectPOs = ajc$this.toSecurableObjectPOs((Set<SecurableObject>)deleteObjects, oldRoleEntity, metalake);
            List<SecurableObjectPO> insertSecurableObjectPOs = ajc$this.toSecurableObjectPOs((Set<SecurableObject>)insertObjects, oldRoleEntity, metalake);
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(RoleMetaMapper.class, mapper -> mapper.updateRoleMeta(POConverters.updateRolePOWithVersion(rolePO, newRoleEntity), rolePO)), () -> {
                if (deleteSecurableObjectPOs.isEmpty()) {
                    return;
                }
                SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.batchSoftDeleteSecurableObjects(deleteSecurableObjectPOs));
            }, () -> {
                if (insertSecurableObjectPOs.isEmpty()) {
                    return;
                }
                SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.batchInsertSecurableObjects(insertSecurableObjectPOs));
            });
            return newRoleEntity;
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.ROLE, identifier.toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object updateRole_aroundBody13$advice(RoleMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        RoleEntity roleEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.updateRole_aroundBody12(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.updateRole_aroundBody12(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                RoleEntity result = RoleMetaService.updateRole_aroundBody12(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                roleEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return roleEntity;
    }

    private static final /* synthetic */ RoleEntity getRoleByIdentifier_aroundBody14(RoleMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        AuthorizationUtils.checkRole(identifier);
        Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(identifier.namespace().level(0));
        RolePO rolePO = RoleMetaService.getRolePOByMetalakeIdAndName(metalakeId, identifier.name());
        List<SecurableObject> securableObjects = RoleMetaService.listSecurableObjects(rolePO);
        return POConverters.fromRolePO(rolePO, securableObjects, identifier.namespace());
    }

    private static final /* synthetic */ Object getRoleByIdentifier_aroundBody15$advice(RoleMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        RoleEntity roleEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.getRoleByIdentifier_aroundBody14(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.getRoleByIdentifier_aroundBody14(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                RoleEntity result = RoleMetaService.getRoleByIdentifier_aroundBody14(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                roleEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return roleEntity;
    }

    private static final /* synthetic */ boolean deleteRole_aroundBody16(RoleMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        AuthorizationUtils.checkRole(identifier);
        Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(identifier.namespace().level(0));
        Long roleId = ajc$this.getRoleIdByMetalakeIdAndName(metalakeId, identifier.name());
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(RoleMetaMapper.class, mapper -> mapper.softDeleteRoleMetaByRoleId(roleId)), () -> SessionUtils.doWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.softDeleteUserRoleRelByRoleId(roleId)), () -> SessionUtils.doWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.softDeleteGroupRoleRelByRoleId(roleId)), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteSecurableObjectsByRoleId(roleId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(roleId, MetadataObject.Type.ROLE.name())));
        return true;
    }

    private static final /* synthetic */ Object deleteRole_aroundBody17$advice(RoleMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)RoleMetaService.deleteRole_aroundBody16(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)RoleMetaService.deleteRole_aroundBody16(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)RoleMetaService.deleteRole_aroundBody16(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ List listSecurableObjectsByRoleId_aroundBody18(Long roleId, JoinPoint joinPoint) {
        return SessionUtils.getWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.listSecurableObjectsByRoleId(roleId));
    }

    private static final /* synthetic */ Object listSecurableObjectsByRoleId_aroundBody19$advice(Long roleId, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listSecurableObjectsByRoleId_aroundBody18(roleId, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listSecurableObjectsByRoleId_aroundBody18(roleId, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = RoleMetaService.listSecurableObjectsByRoleId_aroundBody18(roleId, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ List listRolesByNamespace_aroundBody20(RoleMetaService ajc$this, Namespace namespace, JoinPoint joinPoint) {
        AuthorizationUtils.checkRoleNamespace(namespace);
        String metalakeName = namespace.level(0);
        List rolePOs = SessionUtils.getWithoutCommit(RoleMetaMapper.class, mapper -> mapper.listRolePOsByMetalake(metalakeName));
        return rolePOs.stream().map(po -> POConverters.fromRolePO(po, Collections.emptyList(), AuthorizationUtils.ofRoleNamespace(metalakeName))).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listRolesByNamespace_aroundBody21$advice(RoleMetaService ajc$this, Namespace namespace, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByNamespace_aroundBody20(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return RoleMetaService.listRolesByNamespace_aroundBody20(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = RoleMetaService.listRolesByNamespace_aroundBody20(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ int deleteRoleMetasByLegacyTimeline_aroundBody22(RoleMetaService ajc$this, long legacyTimeline, int limit, JoinPoint joinPoint) {
        int[] roleDeletedCount = new int[]{0};
        int[] userRoleRelDeletedCount = new int[]{0};
        int[] groupRoleRelDeletedCount = new int[]{0};
        int[] securableObjectsCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            roleDeletedCount[0] = SessionUtils.getWithoutCommit(RoleMetaMapper.class, mapper -> mapper.deleteRoleMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            userRoleRelDeletedCount[0] = SessionUtils.getWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.deleteUserRoleRelMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            groupRoleRelDeletedCount[0] = SessionUtils.getWithoutCommit(GroupRoleRelMapper.class, mapper -> mapper.deleteGroupRoleRelMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            securableObjectsCount[0] = SessionUtils.getWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.deleteSecurableObjectsByLegacyTimeline(legacyTimeline, limit));
        });
        return roleDeletedCount[0] + userRoleRelDeletedCount[0] + groupRoleRelDeletedCount[0] + securableObjectsCount[0];
    }

    private static final /* synthetic */ Object deleteRoleMetasByLegacyTimeline_aroundBody23$advice(RoleMetaService ajc$this, long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)RoleMetaService.deleteRoleMetasByLegacyTimeline_aroundBody22(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)RoleMetaService.deleteRoleMetasByLegacyTimeline_aroundBody22(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)RoleMetaService.deleteRoleMetasByLegacyTimeline_aroundBody22(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RoleMetaService.java", RoleMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRoleIdByMetalakeIdAndName", "org.apache.gravitino.storage.relational.service.RoleMetaService", "java.lang.Long:java.lang.String", "metalakeId:roleName", "", "java.lang.Long"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listRolesByUserId", "org.apache.gravitino.storage.relational.service.RoleMetaService", "java.lang.Long", "userId", "", "java.util.List"), 95);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listRolesByNamespace", "org.apache.gravitino.storage.relational.service.RoleMetaService", "org.apache.gravitino.Namespace", "namespace", "", "java.util.List"), 345);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteRoleMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.RoleMetaService", "long:int", "legacyTimeline:limit", "", "int"), 364);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listRolesByUserIdent", "org.apache.gravitino.storage.relational.service.RoleMetaService", "org.apache.gravitino.NameIdentifier", "userIdent", "", "java.util.List"), 103);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listRolesByMetadataObject", "org.apache.gravitino.storage.relational.service.RoleMetaService", "org.apache.gravitino.NameIdentifier:org.apache.gravitino.Entity$EntityType:boolean", "metadataObjectIdent:metadataObjectType:allFields", "", "java.util.List"), 119);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listRolesByGroupId", "org.apache.gravitino.storage.relational.service.RoleMetaService", "java.lang.Long", "groupId", "", "java.util.List"), 147);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertRole", "org.apache.gravitino.storage.relational.service.RoleMetaService", "org.apache.gravitino.meta.RoleEntity:boolean", "roleEntity:overwritten", "java.io.IOException", "void"), 154);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRole", "org.apache.gravitino.storage.relational.service.RoleMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "identifier:updater", "java.io.IOException", "org.apache.gravitino.meta.RoleEntity"), 204);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRoleByIdentifier", "org.apache.gravitino.storage.relational.service.RoleMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "org.apache.gravitino.meta.RoleEntity"), 291);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteRole", "org.apache.gravitino.storage.relational.service.RoleMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "boolean"), 304);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "listSecurableObjectsByRoleId", "org.apache.gravitino.storage.relational.service.RoleMetaService", "java.lang.Long", "roleId", "", "java.util.List"), 337);
    }
}

