/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.po;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class GroupRoleRelPO {
    private Long groupId;
    private Long roleId;
    private String auditInfo;
    private Long currentVersion;
    private Long lastVersion;
    private Long deletedAt;

    public Long getGroupId() {
        return this.groupId;
    }

    public Long getRoleId() {
        return this.roleId;
    }

    public String getAuditInfo() {
        return this.auditInfo;
    }

    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getDeletedAt() {
        return this.deletedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupRoleRelPO)) {
            return false;
        }
        GroupRoleRelPO groupRoleRelPO = (GroupRoleRelPO)o;
        return Objects.equal((Object)this.getGroupId(), (Object)groupRoleRelPO.getGroupId()) && Objects.equal((Object)this.getRoleId(), (Object)groupRoleRelPO.getRoleId()) && Objects.equal((Object)this.getAuditInfo(), (Object)groupRoleRelPO.getAuditInfo()) && Objects.equal((Object)this.getCurrentVersion(), (Object)groupRoleRelPO.getCurrentVersion()) && Objects.equal((Object)this.getLastVersion(), (Object)groupRoleRelPO.getLastVersion()) && Objects.equal((Object)this.getDeletedAt(), (Object)groupRoleRelPO.getDeletedAt());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getGroupId(), this.getRoleId(), this.getAuditInfo(), this.getCurrentVersion(), this.getLastVersion(), this.getDeletedAt()});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GroupRoleRelPO groupRoleRelPO = new GroupRoleRelPO();

        private Builder() {
        }

        public Builder withGroupId(Long groupId) {
            this.groupRoleRelPO.groupId = groupId;
            return this;
        }

        public Builder withRoleId(Long roleId) {
            this.groupRoleRelPO.roleId = roleId;
            return this;
        }

        public Builder withAuditInfo(String auditInfo) {
            this.groupRoleRelPO.auditInfo = auditInfo;
            return this;
        }

        public Builder withCurrentVersion(Long currentVersion) {
            this.groupRoleRelPO.currentVersion = currentVersion;
            return this;
        }

        public Builder withLastVersion(Long lastVersion) {
            this.groupRoleRelPO.lastVersion = lastVersion;
            return this;
        }

        public Builder withDeletedAt(Long deletedAt) {
            this.groupRoleRelPO.deletedAt = deletedAt;
            return this;
        }

        private void validate() {
            Preconditions.checkArgument((this.groupRoleRelPO.groupId != null ? 1 : 0) != 0, (Object)"Group id is required");
            Preconditions.checkArgument((this.groupRoleRelPO.roleId != null ? 1 : 0) != 0, (Object)"Role id is required");
            Preconditions.checkArgument((this.groupRoleRelPO.auditInfo != null ? 1 : 0) != 0, (Object)"Audit info is required");
            Preconditions.checkArgument((this.groupRoleRelPO.currentVersion != null ? 1 : 0) != 0, (Object)"Current version is required");
            Preconditions.checkArgument((this.groupRoleRelPO.lastVersion != null ? 1 : 0) != 0, (Object)"Last version is required");
            Preconditions.checkArgument((this.groupRoleRelPO.deletedAt != null ? 1 : 0) != 0, (Object)"Deleted at is required");
        }

        public GroupRoleRelPO build() {
            this.validate();
            return this.groupRoleRelPO;
        }
    }
}

