/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.RadixTree;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharArrayNodeFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cache.EntityCacheKey;
import org.apache.gravitino.cache.EntityCacheRelationKey;
import org.apache.gravitino.cache.ReverseIndexRules;
import org.apache.gravitino.meta.GenericEntity;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.PolicyEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.TagEntity;
import org.apache.gravitino.meta.UserEntity;

public class ReverseIndexCache {
    private final RadixTree<List<EntityCacheKey>> reverseIndex;
    private final Multimap<Class<? extends Entity>, ReverseIndexRule> reverseIndexRules = HashMultimap.create();
    private final Map<EntityCacheKey, List<EntityCacheKey>> entityToReverseIndexMap = Maps.newHashMap();

    public ReverseIndexCache() {
        this.reverseIndex = new ConcurrentRadixTree((NodeFactory)new DefaultCharArrayNodeFactory());
        this.registerReverseRule(UserEntity.class, ReverseIndexRules.USER_ROLE_REVERSE_RULE);
        this.registerReverseRule(UserEntity.class, ReverseIndexRules.USER_OWNERSHIP_REVERSE_RULE);
        this.registerReverseRule(GroupEntity.class, ReverseIndexRules.GROUP_ROLE_REVERSE_RULE);
        this.registerReverseRule(GroupEntity.class, ReverseIndexRules.GROUP_OWNERSHIP_REVERSE_RULE);
        this.registerReverseRule(RoleEntity.class, ReverseIndexRules.ROLE_SECURABLE_OBJECT_REVERSE_RULE);
        this.registerReverseRule(PolicyEntity.class, ReverseIndexRules.POLICY_SECURABLE_OBJECT_REVERSE_RULE);
        this.registerReverseRule(TagEntity.class, ReverseIndexRules.TAG_SECURABLE_OBJECT_REVERSE_RULE);
        this.registerReverseRule(GenericEntity.class, ReverseIndexRules.GENERIC_METADATA_OBJECT_REVERSE_RULE);
    }

    public Iterable<List<EntityCacheKey>> getValuesForKeysStartingWith(String keyPrefix) {
        return this.reverseIndex.getValuesForKeysStartingWith((CharSequence)keyPrefix);
    }

    public boolean remove(EntityCacheKey key) {
        List<EntityCacheKey> relatedKeys = this.entityToReverseIndexMap.remove(key);
        if (CollectionUtils.isNotEmpty(relatedKeys)) {
            for (EntityCacheKey relatedKey : relatedKeys) {
                List existingKeys = (List)this.reverseIndex.getValueForExactKey((CharSequence)relatedKey.toString());
                if (existingKeys == null || !existingKeys.contains(key)) continue;
                ArrayList newValues = Lists.newArrayList((Iterable)existingKeys);
                newValues.remove(key);
                if (newValues.isEmpty()) {
                    this.reverseIndex.remove((CharSequence)relatedKey.toString());
                    continue;
                }
                this.reverseIndex.put((CharSequence)relatedKey.toString(), (Object)newValues);
            }
        }
        return this.reverseIndex.remove((CharSequence)key.toString());
    }

    public int size() {
        return this.reverseIndex.size();
    }

    public void put(NameIdentifier nameIdentifier, Entity.EntityType type, EntityCacheRelationKey key) {
        EntityCacheKey entityCacheKey = EntityCacheKey.of(nameIdentifier, type);
        this.entityToReverseIndexMap.computeIfAbsent(key, k -> Lists.newArrayList()).add(entityCacheKey);
        List existingKeys = (List)this.reverseIndex.getValueForExactKey((CharSequence)entityCacheKey.toString());
        if (existingKeys == null) {
            this.reverseIndex.put((CharSequence)entityCacheKey.toString(), List.of(key));
        } else {
            if (existingKeys.contains(key)) {
                return;
            }
            ArrayList newValues = Lists.newArrayList((Iterable)existingKeys);
            newValues.add(key);
            this.reverseIndex.put((CharSequence)entityCacheKey.toString(), (Object)newValues);
        }
    }

    public List<EntityCacheKey> get(NameIdentifier nameIdentifier, Entity.EntityType type) {
        EntityCacheKey entityCacheKey = EntityCacheKey.of(nameIdentifier, type);
        return (List)this.reverseIndex.getValueForExactKey((CharSequence)entityCacheKey.toString());
    }

    public void put(Entity entity, EntityCacheRelationKey key) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"EntityCacheRelationKey cannot be null");
        if (entity instanceof HasIdentifier) {
            NameIdentifier nameIdent = ((HasIdentifier)((Object)entity)).nameIdentifier();
            this.put(nameIdent, entity.type(), key);
        }
    }

    public void registerReverseRule(Class<? extends Entity> entityClass, ReverseIndexRule rule) {
        this.reverseIndexRules.put(entityClass, (Object)rule);
    }

    public void indexEntity(Entity entity, EntityCacheRelationKey key) {
        Collection rules = this.reverseIndexRules.get(entity.getClass());
        if (!rules.isEmpty()) {
            for (ReverseIndexRule rule : rules) {
                rule.indexEntity(entity, key, this);
            }
        }
    }

    public String toString() {
        Iterable keys = this.reverseIndex.getKeysStartingWith((CharSequence)"");
        StringBuilder sb = new StringBuilder();
        for (CharSequence key : keys) {
            sb.append(key).append(" -> ").append(this.reverseIndex.getValueForExactKey((CharSequence)key.toString()));
            sb.append("\n");
        }
        return sb.toString();
    }

    @FunctionalInterface
    static interface ReverseIndexRule {
        public void indexEntity(Entity var1, EntityCacheRelationKey var2, ReverseIndexCache var3);
    }
}

