/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.kerberos;

import java.util.Properties;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.hadoop.conf.Configuration;

public class AuthenticationConfig
extends Config {
    public static final String AUTH_TYPE_KEY = "authentication.type";
    public static final String IMPERSONATION_ENABLE_KEY = "authentication.impersonation-enable";
    public static final boolean KERBEROS_DEFAULT_IMPERSONATION_ENABLE = false;
    public static final ConfigEntry<String> AUTH_TYPE_ENTRY = new ConfigBuilder("authentication.type").doc("The type of authentication, currently we only support simple and Kerberos").version("1.0.0").stringConf().createWithDefault((Object)"simple");
    public static final ConfigEntry<Boolean> ENABLE_IMPERSONATION_ENTRY = new ConfigBuilder("authentication.impersonation-enable").doc("Whether to enable impersonation").version("1.0.0").booleanConf().createWithDefault((Object)false);

    public AuthenticationConfig(Properties properties, Configuration configuration) {
        super(false);
        this.loadFromHdfsConfiguration(configuration);
        this.loadFromMap(properties, k -> true);
    }

    private void loadFromHdfsConfiguration(Configuration configuration) {
        String authType = configuration.get("hadoop.security.authentication", "simple");
        this.configMap.put(AUTH_TYPE_KEY, authType);
    }

    public String getAuthType() {
        return (String)this.get(AUTH_TYPE_ENTRY);
    }

    public boolean isKerberosAuth() {
        return AuthenticationType.KERBEROS.name().equalsIgnoreCase(this.getAuthType());
    }

    public boolean isImpersonationEnable() {
        return (Boolean)this.get(ENABLE_IMPERSONATION_ENTRY);
    }

    static enum AuthenticationType {
        SIMPLE,
        KERBEROS;

    }
}

