/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.rel.expressions.literals.Literal;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.partitions.IdentityPartition;

public final class HivePartition
implements IdentityPartition {
    private static final String PARTITION_NAME_DELIMITER = "/";
    private static final String PARTITION_VALUE_DELIMITER = "=";
    private final String name;
    private final String[][] fieldNames;
    private final Literal<?>[] values;
    private final Map<String, String> properties;

    private HivePartition(String name, String[][] fieldNames, Literal<?>[] values, Map<String, String> properties) {
        Preconditions.checkArgument((fieldNames != null ? 1 : 0) != 0, (Object)"Partition field names must not be null");
        Preconditions.checkArgument((values != null ? 1 : 0) != 0, (Object)"Partition values must not be null");
        Preconditions.checkArgument((fieldNames.length == values.length ? 1 : 0) != 0, (String)"Partition field names size %s must equal values size %s", (int)fieldNames.length, (int)values.length);
        Arrays.stream(fieldNames).forEach(fn -> Preconditions.checkArgument((((String[])fn).length == 1 ? 1 : 0) != 0, (Object)"Hive catalog does not support nested partition field names"));
        this.fieldNames = fieldNames;
        this.values = values;
        this.properties = properties;
        this.name = StringUtils.isNotEmpty((CharSequence)name) ? name : this.buildPartitionName();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.name), (Object)"Partition name must not be null or empty");
    }

    public static HivePartition identity(String[][] fieldNames, Literal<?>[] values) {
        return HivePartition.identity(fieldNames, values, Collections.emptyMap());
    }

    public static HivePartition identity(String[][] fieldNames, Literal<?>[] values, Map<String, String> properties) {
        return new HivePartition(null, fieldNames, values, properties);
    }

    public static HivePartition identity(String partitionName) {
        return HivePartition.identity(partitionName, Collections.emptyMap());
    }

    public static HivePartition identity(String partitionName, Map<String, String> properties) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)partitionName), (Object)"Partition name must not be null or empty");
        String[][] fieldNames = HivePartition.extractPartitionFieldNames(partitionName);
        Literal[] values = (Literal[])HivePartition.extractPartitionValues(partitionName).stream().map(Literals::stringLiteral).toArray(Literal[]::new);
        return new HivePartition(partitionName, fieldNames, values, properties);
    }

    public String name() {
        return this.name;
    }

    public String[][] fieldNames() {
        return this.fieldNames;
    }

    public Literal<?>[] values() {
        return this.values;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    private String buildPartitionName() {
        return IntStream.range(0, this.fieldNames.length).mapToObj(idx -> this.fieldNames[idx][0] + PARTITION_VALUE_DELIMITER + String.valueOf(this.values[idx].value())).collect(Collectors.joining(PARTITION_NAME_DELIMITER));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HivePartition)) {
            return false;
        }
        HivePartition that = (HivePartition)o;
        return Objects.equals(this.name, that.name) && Arrays.deepEquals((Object[])this.fieldNames, (Object[])that.fieldNames) && Arrays.equals(this.values, that.values) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.properties);
        result = 31 * result + Arrays.deepHashCode((Object[])this.fieldNames);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public static List<String> extractPartitionValues(String partitionName) {
        if (StringUtils.isEmpty((CharSequence)partitionName)) {
            return Collections.emptyList();
        }
        return Arrays.stream(partitionName.split(PARTITION_NAME_DELIMITER)).map(field -> {
            String[] kv = field.split(PARTITION_VALUE_DELIMITER, 2);
            return kv.length > 1 ? kv[1] : "";
        }).collect(Collectors.toList());
    }

    public static List<String> extractPartitionValues(List<String> partitionFieldNames, String partitionSpec) {
        Preconditions.checkArgument((partitionFieldNames != null ? 1 : 0) != 0, (Object)"Partition field names must not be null");
        if (partitionFieldNames.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap partSpecMap = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)partitionSpec)) {
            Arrays.stream(partitionSpec.split(PARTITION_NAME_DELIMITER)).forEach(part -> {
                String[] keyValue = part.split(PARTITION_VALUE_DELIMITER, 2);
                if (keyValue.length != 2) {
                    throw new IllegalArgumentException(String.format("Invalid partition format: %s", partitionSpec));
                }
                if (!partitionFieldNames.contains(keyValue[0])) {
                    throw new NoSuchPartitionException("Hive partition %s does not exist in Hive Metastore", new Object[]{partitionSpec});
                }
                partSpecMap.put(keyValue[0], keyValue[1]);
            });
        }
        return partitionFieldNames.stream().map(key -> partSpecMap.getOrDefault(key, "")).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    public static String[][] extractPartitionFieldNames(String partitionName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ String[][] lambda$extractPartitionFieldNames$7(int x$0) {
        return new String[x$0][];
    }
}

