/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ContractValidationException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyReservationAgent
implements ReservationAgent {
    private static final Logger LOG = LoggerFactory.getLogger(GreedyReservationAgent.class);

    @Override
    public boolean createReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        return this.computeAllocation(reservationId, user, plan, contract, null);
    }

    @Override
    public boolean updateReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        return this.computeAllocation(reservationId, user, plan, contract, plan.getReservationById(reservationId));
    }

    @Override
    public boolean deleteReservation(ReservationId reservationId, String user, Plan plan) throws PlanningException {
        return plan.deleteReservation(reservationId);
    }

    private boolean computeAllocation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract, ReservationAllocation oldReservation) throws PlanningException, ContractValidationException {
        long deadline;
        LOG.info("placing the following ReservationRequest: " + contract);
        Resource totalCapacity = plan.getTotalCapacity();
        long earliestStart = contract.getArrival();
        long step = plan.getStep();
        if (earliestStart % step != 0L) {
            earliestStart += step - earliestStart % step;
        }
        long curDeadline = deadline = contract.getDeadline() - contract.getDeadline() % plan.getStep();
        long oldDeadline = -1L;
        HashMap<ReservationInterval, ReservationRequest> allocations = new HashMap<ReservationInterval, ReservationRequest>();
        RLESparseResourceAllocation tempAssigned = new RLESparseResourceAllocation(plan.getResourceCalculator(), plan.getMinimumAllocation());
        List stages = contract.getReservationRequests().getReservationResources();
        ReservationRequestInterpreter type = contract.getReservationRequests().getInterpreter();
        ListIterator li = stages.listIterator(stages.size());
        while (li.hasPrevious()) {
            ReservationRequest currentReservationStage = (ReservationRequest)li.previous();
            this.validateInput(plan, currentReservationStage, totalCapacity);
            Map<ReservationInterval, ReservationRequest> curAlloc = this.placeSingleStage(plan, tempAssigned, currentReservationStage, earliestStart, curDeadline, oldReservation, totalCapacity);
            if (curAlloc == null) {
                if (type == ReservationRequestInterpreter.R_ANY) continue;
                throw new PlanningException("The GreedyAgent couldn't find a valid allocation for your request");
            }
            allocations.putAll(curAlloc);
            if (type == ReservationRequestInterpreter.R_ANY) break;
            if (type != ReservationRequestInterpreter.R_ORDER && type != ReservationRequestInterpreter.R_ORDER_NO_GAP) continue;
            curDeadline = this.findEarliestTime(curAlloc.keySet());
            if (type == ReservationRequestInterpreter.R_ORDER_NO_GAP && oldDeadline > 0L && oldDeadline - this.findLatestTime(curAlloc.keySet()) > plan.getStep()) {
                throw new PlanningException("The GreedyAgent couldn't find a valid allocation for your request");
            }
            oldDeadline = curDeadline;
        }
        if (allocations.isEmpty()) {
            throw new PlanningException("The GreedyAgent couldn't find a valid allocation for your request");
        }
        ReservationRequest ZERO_RES = ReservationRequest.newInstance((Resource)Resource.newInstance((int)0, (int)0), (int)0);
        long firstStartTime = this.findEarliestTime(allocations.keySet());
        if (firstStartTime > earliestStart) {
            allocations.put(new ReservationInterval(earliestStart, firstStartTime), ZERO_RES);
            firstStartTime = earliestStart;
        }
        InMemoryReservationAllocation capReservation = new InMemoryReservationAllocation(reservationId, contract, user, plan.getQueueName(), firstStartTime, this.findLatestTime(allocations.keySet()), allocations, plan.getResourceCalculator(), plan.getMinimumAllocation());
        if (oldReservation != null) {
            return plan.updateReservation(capReservation);
        }
        return plan.addReservation(capReservation);
    }

    private void validateInput(Plan plan, ReservationRequest rr, Resource totalCapacity) throws ContractValidationException {
        if (rr.getConcurrency() < 1) {
            throw new ContractValidationException("Gang Size should be >= 1");
        }
        if (rr.getNumContainers() <= 0) {
            throw new ContractValidationException("Num containers should be >= 0");
        }
        if (rr.getNumContainers() % rr.getConcurrency() != 0) {
            throw new ContractValidationException("Parallelism must be an exact multiple of gang size");
        }
        if (Resources.greaterThan((ResourceCalculator)plan.getResourceCalculator(), (Resource)totalCapacity, (Resource)rr.getCapability(), (Resource)plan.getMaximumAllocation())) {
            throw new ContractValidationException("Individual capability requests should not exceed cluster's maxAlloc");
        }
    }

    private Map<ReservationInterval, ReservationRequest> placeSingleStage(Plan plan, RLESparseResourceAllocation tempAssigned, ReservationRequest rr, long earliestStart, long curDeadline, ReservationAllocation oldResAllocation, Resource totalCapacity) {
        long step;
        HashMap<ReservationInterval, ReservationRequest> allocationRequests = new HashMap<ReservationInterval, ReservationRequest>();
        Resource gang = Resources.multiply((Resource)rr.getCapability(), (double)rr.getConcurrency());
        long dur = rr.getDuration();
        if (dur % (step = plan.getStep()) != 0L) {
            dur += step - dur % step;
        }
        int gangsToPlace = rr.getNumContainers() / rr.getConcurrency();
        int maxGang = 0;
        while (gangsToPlace > 0 && curDeadline - dur >= earliestStart) {
            maxGang = gangsToPlace;
            long minPoint = curDeadline;
            int curMaxGang = maxGang;
            for (long t = curDeadline - plan.getStep(); t >= curDeadline - dur && maxGang > 0; t -= plan.getStep()) {
                Resource oldResCap = Resource.newInstance((int)0, (int)0);
                if (oldResAllocation != null) {
                    oldResCap = oldResAllocation.getResourcesAtTime(t);
                }
                Resource netAvailableRes = Resources.clone((Resource)totalCapacity);
                Resources.addTo((Resource)netAvailableRes, (Resource)oldResCap);
                Resources.subtractFrom((Resource)netAvailableRes, (Resource)plan.getTotalCommittedResources(t));
                Resources.subtractFrom((Resource)netAvailableRes, (Resource)tempAssigned.getCapacityAtTime(t));
                curMaxGang = (int)Math.floor(Resources.divide((ResourceCalculator)plan.getResourceCalculator(), (Resource)totalCapacity, (Resource)netAvailableRes, (Resource)gang));
                curMaxGang = Math.min(gangsToPlace, curMaxGang);
                if (curMaxGang > maxGang) continue;
                maxGang = curMaxGang;
                minPoint = t;
            }
            if (maxGang > 0) {
                gangsToPlace -= maxGang;
                ReservationInterval reservationInt = new ReservationInterval(curDeadline - dur, curDeadline);
                ReservationRequest reservationRes = ReservationRequest.newInstance((Resource)rr.getCapability(), (int)(rr.getConcurrency() * maxGang), (int)rr.getConcurrency(), (long)rr.getDuration());
                tempAssigned.addInterval(reservationInt, reservationRes);
                allocationRequests.put(reservationInt, reservationRes);
            }
            curDeadline = minPoint;
        }
        if (gangsToPlace == 0) {
            return allocationRequests;
        }
        for (Map.Entry tempAllocation : allocationRequests.entrySet()) {
            tempAssigned.removeInterval((ReservationInterval)tempAllocation.getKey(), (ReservationRequest)tempAllocation.getValue());
        }
        return null;
    }

    private long findEarliestTime(Set<ReservationInterval> resInt) {
        long ret = Long.MAX_VALUE;
        for (ReservationInterval s : resInt) {
            if (s.getStartTime() >= ret) continue;
            ret = s.getStartTime();
        }
        return ret;
    }

    private long findLatestTime(Set<ReservationInterval> resInt) {
        long ret = Long.MIN_VALUE;
        for (ReservationInterval s : resInt) {
            if (s.getEndTime() <= ret) continue;
            ret = s.getEndTime();
        }
        return ret;
    }
}

