/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferAllocator;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ByteBufferArray {
    private static final Log LOG = LogFactory.getLog(ByteBufferArray.class);
    public static final int DEFAULT_BUFFER_SIZE = 0x400000;
    @VisibleForTesting
    ByteBuffer[] buffers;
    private int bufferSize = 0x400000;
    @VisibleForTesting
    int bufferCount;
    private static final Visitor GET_MULTIPLE_VISTOR = new Visitor(){

        @Override
        public void visit(ByteBuffer bb, int pos, byte[] array, int arrayIdx, int len) {
            ByteBufferUtils.copyFromBufferToArray(array, bb, pos, arrayIdx, len);
        }
    };
    private static final Visitor PUT_MULTIPLE_VISITOR = new Visitor(){

        @Override
        public void visit(ByteBuffer bb, int pos, byte[] array, int arrayIdx, int len) {
            ByteBufferUtils.copyFromArrayToBuffer(bb, pos, array, arrayIdx, len);
        }
    };

    public ByteBufferArray(long capacity, boolean directByteBuffer, ByteBufferAllocator allocator) throws IOException {
        if ((long)this.bufferSize > capacity / 16L) {
            this.bufferSize = (int)this.roundUp(capacity / 16L, 32768L);
        }
        this.bufferCount = (int)(this.roundUp(capacity, this.bufferSize) / (long)this.bufferSize);
        LOG.info((Object)("Allocating buffers total=" + StringUtils.byteDesc((long)capacity) + ", sizePerBuffer=" + StringUtils.byteDesc((long)this.bufferSize) + ", count=" + this.bufferCount + ", direct=" + directByteBuffer));
        this.buffers = new ByteBuffer[this.bufferCount + 1];
        this.createBuffers(directByteBuffer, allocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void createBuffers(boolean directByteBuffer, ByteBufferAllocator allocator) throws IOException {
        int threadCount = this.getThreadCount();
        ThreadPoolExecutor service = new ThreadPoolExecutor(threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        int perThreadCount = (int)Math.floor((double)this.bufferCount / (double)threadCount);
        int lastThreadCount = this.bufferCount - perThreadCount * (threadCount - 1);
        Future[] futures = new Future[threadCount];
        try {
            for (int i = 0; i < threadCount; ++i) {
                int buffersToCreate = i == threadCount - 1 ? lastThreadCount : perThreadCount;
                futures[i] = service.submit(new BufferCreatorCallable(this.bufferSize, directByteBuffer, buffersToCreate, allocator));
            }
            int bufferIndex = 0;
            for (Future future : futures) {
                try {
                    ByteBuffer[] buffers;
                    for (ByteBuffer buffer : buffers = (ByteBuffer[])future.get()) {
                        this.buffers[bufferIndex++] = buffer;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error((Object)"Buffer creation interrupted", (Throwable)e);
                    throw new IOException(e);
                }
            }
        }
        finally {
            service.shutdownNow();
        }
        this.buffers[this.bufferCount] = ByteBuffer.allocate(0);
    }

    @VisibleForTesting
    int getThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    private long roundUp(long n, long to) {
        return (n + to - 1L) / to * to;
    }

    public int getMultiple(long start, int len, byte[] dstArray) {
        return this.getMultiple(start, len, dstArray, 0);
    }

    public int getMultiple(long start, int len, byte[] dstArray, int dstOffset) {
        this.multiple(start, len, dstArray, dstOffset, GET_MULTIPLE_VISTOR);
        return len;
    }

    public void putMultiple(long start, int len, byte[] srcArray) {
        this.putMultiple(start, len, srcArray, 0);
    }

    public void putMultiple(long start, int len, byte[] srcArray, int srcOffset) {
        this.multiple(start, len, srcArray, srcOffset, PUT_MULTIPLE_VISITOR);
    }

    void multiple(long start, int len, byte[] array, int arrayOffset, Visitor visitor) {
        assert (len >= 0);
        long end = start + (long)len;
        int startBuffer = (int)(start / (long)this.bufferSize);
        int startOffset = (int)(start % (long)this.bufferSize);
        int endBuffer = (int)(end / (long)this.bufferSize);
        int endOffset = (int)(end % (long)this.bufferSize);
        assert (array.length >= len + arrayOffset);
        assert (startBuffer >= 0 && startBuffer < this.bufferCount);
        assert (endBuffer >= 0 && endBuffer < this.bufferCount || endBuffer == this.bufferCount && endOffset == 0);
        if (startBuffer >= this.buffers.length || startBuffer < 0) {
            String msg = "Failed multiple, start=" + start + ",startBuffer=" + startBuffer + ",bufferSize=" + this.bufferSize;
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
        int srcIndex = 0;
        int cnt = -1;
        for (int i = startBuffer; i <= endBuffer; ++i) {
            ByteBuffer bb = this.buffers[i].duplicate();
            int pos = 0;
            if (i == startBuffer) {
                cnt = this.bufferSize - startOffset;
                if (cnt > len) {
                    cnt = len;
                }
                pos = startOffset;
            } else {
                cnt = i == endBuffer ? endOffset : this.bufferSize;
            }
            visitor.visit(bb, pos, array, srcIndex + arrayOffset, cnt);
            srcIndex += cnt;
        }
        assert (srcIndex == len);
    }

    public ByteBuff asSubByteBuff(long offset, int len) {
        assert (len >= 0);
        long end = offset + (long)len;
        int startBuffer = (int)(offset / (long)this.bufferSize);
        int startBufferOffset = (int)(offset % (long)this.bufferSize);
        int endBuffer = (int)(end / (long)this.bufferSize);
        int endBufferOffset = (int)(end % (long)this.bufferSize);
        if (endBuffer == this.bufferCount) {
            --endBuffer;
            endBufferOffset = this.bufferSize;
        }
        assert (startBuffer >= 0 && startBuffer < this.bufferCount);
        assert (endBuffer >= 0 && endBuffer < this.bufferCount || endBuffer == this.bufferCount && endBufferOffset == 0);
        if (startBuffer >= this.buffers.length || startBuffer < 0) {
            String msg = "Failed subArray, start=" + offset + ",startBuffer=" + startBuffer + ",bufferSize=" + this.bufferSize;
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
        int srcIndex = 0;
        int cnt = -1;
        ByteBuffer[] mbb = new ByteBuffer[endBuffer - startBuffer + 1];
        int i = startBuffer;
        int j = 0;
        while (i <= endBuffer) {
            ByteBuffer bb = this.buffers[i].duplicate();
            if (i == startBuffer) {
                cnt = this.bufferSize - startBufferOffset;
                if (cnt > len) {
                    cnt = len;
                }
                bb.limit(startBufferOffset + cnt).position(startBufferOffset);
            } else if (i == endBuffer) {
                cnt = endBufferOffset;
                bb.position(0).limit(cnt);
            } else {
                cnt = this.bufferSize;
                bb.position(0).limit(cnt);
            }
            mbb[j] = bb.slice();
            srcIndex += cnt;
            ++i;
            ++j;
        }
        assert (srcIndex == len);
        if (mbb.length > 1) {
            return new MultiByteBuff(mbb);
        }
        return new SingleByteBuff(mbb[0]);
    }

    private static interface Visitor {
        public void visit(ByteBuffer var1, int var2, byte[] var3, int var4, int var5);
    }

    private static class BufferCreatorCallable
    implements Callable<ByteBuffer[]> {
        private final int bufferCapacity;
        private final boolean directByteBuffer;
        private final int bufferCount;
        private final ByteBufferAllocator allocator;

        BufferCreatorCallable(int bufferCapacity, boolean directByteBuffer, int bufferCount, ByteBufferAllocator allocator) {
            this.bufferCapacity = bufferCapacity;
            this.directByteBuffer = directByteBuffer;
            this.bufferCount = bufferCount;
            this.allocator = allocator;
        }

        @Override
        public ByteBuffer[] call() throws Exception {
            ByteBuffer[] buffers = new ByteBuffer[this.bufferCount];
            for (int i = 0; i < this.bufferCount; ++i) {
                buffers[i] = this.allocator.allocate(this.bufferCapacity, this.directByteBuffer);
            }
            return buffers;
        }
    }
}

