/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.shaded.org.apache.curator.CuratorZookeeperClient;
import org.apache.hadoop.shaded.org.apache.curator.RetryPolicy;
import org.apache.hadoop.shaded.org.apache.curator.RetrySleeper;
import org.apache.hadoop.shaded.org.apache.curator.drivers.EventTrace;
import org.apache.hadoop.shaded.org.apache.curator.drivers.TracerDriver;
import org.apache.hadoop.shaded.org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryLoop {
    private boolean isDone = false;
    private int retryCount = 0;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final long startTimeMs = System.currentTimeMillis();
    private final RetryPolicy retryPolicy;
    private final AtomicReference<TracerDriver> tracer;
    private static final RetrySleeper sleeper = new RetrySleeper(){

        @Override
        public void sleepFor(long time, TimeUnit unit) throws InterruptedException {
            unit.sleep(time);
        }
    };

    public static RetrySleeper getDefaultRetrySleeper() {
        return sleeper;
    }

    public static <T> T callWithRetry(CuratorZookeeperClient client, Callable<T> proc) throws Exception {
        return client.getConnectionHandlingPolicy().callWithRetry(client, proc);
    }

    RetryLoop(RetryPolicy retryPolicy, AtomicReference<TracerDriver> tracer) {
        this.retryPolicy = retryPolicy;
        this.tracer = tracer;
    }

    public boolean shouldContinue() {
        return !this.isDone;
    }

    public void markComplete() {
        this.isDone = true;
    }

    public static boolean shouldRetry(int rc) {
        return rc == KeeperException.Code.CONNECTIONLOSS.intValue() || rc == KeeperException.Code.OPERATIONTIMEOUT.intValue() || rc == KeeperException.Code.SESSIONMOVED.intValue() || rc == KeeperException.Code.SESSIONEXPIRED.intValue() || rc == -13;
    }

    public static boolean isRetryException(Throwable exception) {
        if (exception instanceof KeeperException) {
            KeeperException keeperException = (KeeperException)exception;
            return RetryLoop.shouldRetry(keeperException.code().intValue());
        }
        return false;
    }

    public void takeException(Exception exception) throws Exception {
        boolean rethrow = true;
        if (RetryLoop.isRetryException(exception)) {
            if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                this.log.debug("Retry-able exception received", (Throwable)exception);
            }
            if (this.retryPolicy.allowRetry(this.retryCount++, System.currentTimeMillis() - this.startTimeMs, sleeper)) {
                new EventTrace("retries-allowed", this.tracer.get()).commit();
                if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                    this.log.debug("Retrying operation");
                }
                rethrow = false;
            } else {
                new EventTrace("retries-disallowed", this.tracer.get()).commit();
                if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                    this.log.debug("Retry policy not allowing retry");
                }
            }
        }
        if (rethrow) {
            throw exception;
        }
    }
}

