/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.RowType;

public class FieldCollectAgg
extends FieldAggregator {
    private static final long serialVersionUID = 1L;
    private final boolean distinct;
    private final InternalArray.ElementGetter elementGetter;
    @Nullable
    private final BiFunction<Object, Object, Boolean> equaliser;

    public FieldCollectAgg(String name, ArrayType dataType, boolean distinct) {
        super(name, (DataType)dataType);
        this.distinct = distinct;
        this.elementGetter = InternalArray.createElementGetter((DataType)dataType.getElementType());
        if (distinct && dataType.getElementType().getTypeRoot().getFamilies().contains(DataTypeFamily.CONSTRUCTED)) {
            DataType elementType = dataType.getElementType();
            List fieldTypes = elementType instanceof RowType ? ((RowType)elementType).getFieldTypes() : Collections.singletonList(elementType);
            RecordEqualiser elementEqualiser = CodeGenUtils.newRecordEqualiser(fieldTypes);
            this.equaliser = (o1, o2) -> {
                InternalRow row2;
                InternalRow row1;
                if (elementType instanceof RowType) {
                    row1 = (InternalRow)o1;
                    row2 = (InternalRow)o2;
                } else {
                    row1 = GenericRow.of((Object[])new Object[]{o1});
                    row2 = GenericRow.of((Object[])new Object[]{o2});
                }
                return elementEqualiser.equals(row1, row2);
            };
        } else {
            this.equaliser = null;
        }
    }

    @Override
    public Object aggReversed(Object accumulator, Object inputField) {
        return this.agg(accumulator, inputField);
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        if (accumulator == null && inputField == null) {
            return null;
        }
        if (!(accumulator != null && inputField != null || this.distinct)) {
            return accumulator == null ? inputField : accumulator;
        }
        if (this.equaliser != null) {
            ArrayList<Object> collection = new ArrayList<Object>();
            this.collect(collection, accumulator);
            this.collectWithEqualiser(collection, inputField);
            return new GenericArray(collection.toArray());
        }
        HashSet<Object> collection = this.distinct ? new HashSet() : new ArrayList();
        this.collect(collection, accumulator);
        this.collect(collection, inputField);
        return new GenericArray(collection.toArray());
    }

    private void collect(Collection<Object> collection, @Nullable Object data) {
        if (data == null) {
            return;
        }
        InternalArray array = (InternalArray)data;
        for (int i = 0; i < array.size(); ++i) {
            collection.add(this.elementGetter.getElementOrNull(array, i));
        }
    }

    private void collectWithEqualiser(List<Object> list, Object data) {
        if (data == null) {
            return;
        }
        InternalArray array = (InternalArray)data;
        for (int i = 0; i < array.size(); ++i) {
            Object element = this.elementGetter.getElementOrNull(array, i);
            if (this.contains(list, element)) continue;
            list.add(element);
        }
    }

    private boolean contains(List<Object> list, @Nullable Object element) {
        if (element == null) {
            return list.contains(null);
        }
        for (Object o : list) {
            if (!this.equaliser.apply(o, element).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object retract(Object accumulator, Object retractField) {
        if (accumulator == null) {
            return null;
        }
        if (retractField == null) {
            return accumulator;
        }
        InternalArray retract = (InternalArray)retractField;
        if (retract.size() == 0) {
            return accumulator;
        }
        ArrayList<Object> retractedElements = new ArrayList<Object>();
        for (int i = 0; i < retract.size(); ++i) {
            retractedElements.add(this.elementGetter.getElementOrNull(retract, i));
        }
        InternalArray acc = (InternalArray)accumulator;
        ArrayList<Object> accElements = new ArrayList<Object>();
        for (int i = 0; i < acc.size(); ++i) {
            Object candidate = this.elementGetter.getElementOrNull(acc, i);
            if (this.retract(retractedElements, candidate)) continue;
            accElements.add(candidate);
        }
        return new GenericArray(accElements.toArray());
    }

    private boolean retract(List<Object> list, Object element) {
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!this.equals(o, element)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return this.equaliser == null ? a.equals(b) : this.equaliser.apply(a, b).booleanValue();
    }
}

