/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors.append;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.deletionvectors.append.BaseAppendDeleteFileMaintainer;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;

public class BucketedAppendDeleteFileMaintainer
implements BaseAppendDeleteFileMaintainer {
    private final BinaryRow partition;
    private final int bucket;
    private final DeletionVectorsMaintainer maintainer;

    BucketedAppendDeleteFileMaintainer(BinaryRow partition, int bucket, DeletionVectorsMaintainer maintainer) {
        this.partition = partition;
        this.bucket = bucket;
        this.maintainer = maintainer;
    }

    @Override
    public BinaryRow getPartition() {
        return this.partition;
    }

    @Override
    public int getBucket() {
        return this.bucket;
    }

    @Override
    public void notifyNewDeletionVector(String dataFile, DeletionVector deletionVector) {
        this.maintainer.mergeNewDeletion(dataFile, deletionVector);
    }

    @Override
    public List<IndexManifestEntry> persist() {
        return this.maintainer.writeDeletionVectorsIndex().stream().map(fileMeta -> new IndexManifestEntry(FileKind.ADD, this.partition, this.bucket, (IndexFileMeta)fileMeta)).collect(Collectors.toList());
    }
}

