/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.zookeeper;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import java.util.concurrent.Executor;
import org.apache.twill.zookeeper.ForwardingZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.zookeeper.ZooKeeper;

public abstract class ForwardingZKClientService
extends ForwardingZKClient
implements ZKClientService {
    private final ZKClientService delegate;

    protected ForwardingZKClientService(ZKClientService delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    public Supplier<ZooKeeper> getZooKeeperSupplier() {
        return this.delegate.getZooKeeperSupplier();
    }

    public ListenableFuture<Service.State> start() {
        return this.delegate.start();
    }

    public Service.State startAndWait() {
        return (Service.State)Futures.getUnchecked(this.start());
    }

    public boolean isRunning() {
        return this.delegate.isRunning();
    }

    public Service.State state() {
        return this.delegate.state();
    }

    public ListenableFuture<Service.State> stop() {
        return this.delegate.stop();
    }

    public Service.State stopAndWait() {
        return (Service.State)Futures.getUnchecked(this.stop());
    }

    public void addListener(Service.Listener listener, Executor executor) {
        this.delegate.addListener(listener, executor);
    }
}

