/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lineage;

import com.google.common.collect.ImmutableSet;
import io.openlineage.server.OpenLineage;
import java.util.Set;
import org.apache.gravitino.lineage.LineageConfig;
import org.apache.gravitino.lineage.LineageDispatcher;
import org.apache.gravitino.lineage.processor.LineageProcessor;
import org.apache.gravitino.lineage.sink.LineageSinkManager;
import org.apache.gravitino.lineage.source.LineageSource;
import org.apache.gravitino.server.web.SupportsRESTPackages;
import org.apache.gravitino.utils.ClassUtils;

public class LineageService
implements LineageDispatcher,
SupportsRESTPackages {
    private LineageSinkManager sinkManager;
    private LineageSource source;
    private LineageProcessor processor;

    @Override
    public void initialize(LineageConfig lineageConfig) {
        String sourceName = lineageConfig.source();
        String sourceClass = lineageConfig.sourceClass();
        this.source = (LineageSource)ClassUtils.loadAndGetInstance((String)sourceClass);
        this.sinkManager = new LineageSinkManager();
        String processorClassName = lineageConfig.processorClass();
        this.processor = (LineageProcessor)ClassUtils.loadAndGetInstance((String)processorClassName);
        this.sinkManager.initialize(lineageConfig.sinks(), lineageConfig.getSinkConfigs());
        this.source.initialize(lineageConfig.getConfigsWithPrefix(sourceName), this);
    }

    @Override
    public void close() {
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
        if (this.sinkManager != null) {
            this.sinkManager.close();
            this.sinkManager = null;
        }
    }

    @Override
    public boolean dispatchLineageEvent(OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            return false;
        }
        if (this.sinkManager.isHighWatermark()) {
            return false;
        }
        OpenLineage.RunEvent newEvent = this.processor.process(runEvent);
        this.sinkManager.sink(newEvent);
        return true;
    }

    public Set<String> getRESTPackages() {
        if (this.source instanceof SupportsRESTPackages) {
            return ((SupportsRESTPackages)this.source).getRESTPackages();
        }
        return ImmutableSet.of();
    }
}

