/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.MultiServerCallable;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.ResultStatsUtil;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;

@InterfaceAudience.Private
public class StatsTrackingRpcRetryingCaller<T>
extends RpcRetryingCaller<T> {
    private final ServerStatisticTracker stats;

    public StatsTrackingRpcRetryingCaller(long pause, int retries, int startLogErrorsCnt, ServerStatisticTracker stats) {
        super(pause, retries, startLogErrorsCnt);
        this.stats = stats;
    }

    public StatsTrackingRpcRetryingCaller(long pause, int retries, RetryingCallerInterceptor interceptor, int startLogErrorsCnt, ServerStatisticTracker stats) {
        super(pause, retries, interceptor, startLogErrorsCnt);
        this.stats = stats;
    }

    @Override
    public T callWithRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        T result = super.callWithRetries(callable, callTimeout);
        return this.updateStatsAndUnwrap(result, callable);
    }

    @Override
    public T callWithoutRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        T result = super.callWithRetries(callable, callTimeout);
        return this.updateStatsAndUnwrap(result, callable);
    }

    private T updateStatsAndUnwrap(T result, RetryingCallable<T> callable) {
        if (!(callable instanceof RegionServerCallable)) {
            return result;
        }
        if (callable instanceof MultiServerCallable) {
            return result;
        }
        RegionServerCallable regionCallable = (RegionServerCallable)callable;
        HRegionLocation location = regionCallable.getLocation();
        return ResultStatsUtil.updateStats(result, this.stats, location);
    }
}

