/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.metrics.CommitMetricsResult;
import org.apache.iceberg.metrics.CommitReport;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitReport", generator="Immutables")
@Immutable
public final class ImmutableCommitReport
implements CommitReport {
    private final String tableName;
    private final long snapshotId;
    private final long sequenceNumber;
    private final String operation;
    private final CommitMetricsResult commitMetrics;
    private final Map<String, String> metadata;

    private ImmutableCommitReport(String tableName, long snapshotId, long sequenceNumber, String operation, CommitMetricsResult commitMetrics, Map<String, String> metadata) {
        this.tableName = tableName;
        this.snapshotId = snapshotId;
        this.sequenceNumber = sequenceNumber;
        this.operation = operation;
        this.commitMetrics = commitMetrics;
        this.metadata = metadata;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public CommitMetricsResult commitMetrics() {
        return this.commitMetrics;
    }

    @Override
    public Map<String, String> metadata() {
        return this.metadata;
    }

    public final ImmutableCommitReport withTableName(String value) {
        String newValue = Objects.requireNonNull(value, "tableName");
        if (this.tableName.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitReport(newValue, this.snapshotId, this.sequenceNumber, this.operation, this.commitMetrics, this.metadata);
    }

    public final ImmutableCommitReport withSnapshotId(long value) {
        if (this.snapshotId == value) {
            return this;
        }
        return new ImmutableCommitReport(this.tableName, value, this.sequenceNumber, this.operation, this.commitMetrics, this.metadata);
    }

    public final ImmutableCommitReport withSequenceNumber(long value) {
        if (this.sequenceNumber == value) {
            return this;
        }
        return new ImmutableCommitReport(this.tableName, this.snapshotId, value, this.operation, this.commitMetrics, this.metadata);
    }

    public final ImmutableCommitReport withOperation(String value) {
        String newValue = Objects.requireNonNull(value, "operation");
        if (this.operation.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitReport(this.tableName, this.snapshotId, this.sequenceNumber, newValue, this.commitMetrics, this.metadata);
    }

    public final ImmutableCommitReport withCommitMetrics(CommitMetricsResult value) {
        if (this.commitMetrics == value) {
            return this;
        }
        CommitMetricsResult newValue = Objects.requireNonNull(value, "commitMetrics");
        return new ImmutableCommitReport(this.tableName, this.snapshotId, this.sequenceNumber, this.operation, newValue, this.metadata);
    }

    public final ImmutableCommitReport withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableCommitReport.createUnmodifiableMap(true, false, entries);
        return new ImmutableCommitReport(this.tableName, this.snapshotId, this.sequenceNumber, this.operation, this.commitMetrics, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitReport && this.equalTo(0, (ImmutableCommitReport)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitReport another) {
        return this.tableName.equals(another.tableName) && this.snapshotId == another.snapshotId && this.sequenceNumber == another.sequenceNumber && this.operation.equals(another.operation) && this.commitMetrics.equals(another.commitMetrics) && this.metadata.equals(another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tableName.hashCode();
        h += (h << 5) + Long.hashCode(this.snapshotId);
        h += (h << 5) + Long.hashCode(this.sequenceNumber);
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + this.commitMetrics.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        return h;
    }

    public String toString() {
        return "CommitReport{tableName=" + this.tableName + ", snapshotId=" + this.snapshotId + ", sequenceNumber=" + this.sequenceNumber + ", operation=" + this.operation + ", commitMetrics=" + String.valueOf(this.commitMetrics) + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    public static ImmutableCommitReport copyOf(CommitReport instance) {
        if (instance instanceof ImmutableCommitReport) {
            return (ImmutableCommitReport)instance;
        }
        return ImmutableCommitReport.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="CommitReport", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TABLE_NAME = 1L;
        private static final long INIT_BIT_SNAPSHOT_ID = 2L;
        private static final long INIT_BIT_SEQUENCE_NUMBER = 4L;
        private static final long INIT_BIT_OPERATION = 8L;
        private static final long INIT_BIT_COMMIT_METRICS = 16L;
        private long initBits = 31L;
        @Nullable
        private String tableName;
        private long snapshotId;
        private long sequenceNumber;
        @Nullable
        private String operation;
        @Nullable
        private CommitMetricsResult commitMetrics;
        private Map<String, String> metadata = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitReport instance) {
            Objects.requireNonNull(instance, "instance");
            this.tableName(instance.tableName());
            this.snapshotId(instance.snapshotId());
            this.sequenceNumber(instance.sequenceNumber());
            this.operation(instance.operation());
            this.commitMetrics(instance.commitMetrics());
            this.putAllMetadata(instance.metadata());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tableName(String tableName) {
            this.tableName = Objects.requireNonNull(tableName, "tableName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder operation(String operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitMetrics(CommitMetricsResult commitMetrics) {
            this.commitMetrics = Objects.requireNonNull(commitMetrics, "commitMetrics");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMetadata(String key, String value) {
            this.metadata.put(Objects.requireNonNull(key, "metadata key"), Objects.requireNonNull(value, value == null ? "metadata value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "metadata value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadata(Map<String, ? extends String> entries) {
            this.metadata.clear();
            return this.putAllMetadata(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMetadata(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "metadata value for key: " + k : null));
            }
            return this;
        }

        public ImmutableCommitReport build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitReport(this.tableName, this.snapshotId, this.sequenceNumber, this.operation, this.commitMetrics, ImmutableCommitReport.createUnmodifiableMap(false, false, this.metadata));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tableName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("snapshotId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sequenceNumber");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("commitMetrics");
            }
            return "Cannot build CommitReport, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

