/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.PolicyMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.PolicyPO;

public class PolicyMetaPostgreSQLProvider
extends PolicyMetaBaseSQLProvider {
    @Override
    public String softDeletePolicyByMetalakeAndPolicyName(String metalakeName, String policyName) {
        return "UPDATE policy_meta SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE metalake_id = (SELECT metalake_id FROM  metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND policy_name = #{policyName} AND deleted_at = 0";
    }

    @Override
    public String softDeletePolicyMetasByMetalakeId(Long metalakeId) {
        return "UPDATE policy_meta SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String deletePolicyMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        return "DELETE FROM policy_meta WHERE policy_id IN (SELECT policy_id FROM policy_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }

    @Override
    public String insertPolicyMetaOnDuplicateKeyUpdate(PolicyPO policyPO) {
        return "INSERT INTO policy_meta (policy_id, policy_name, policy_type, metalake_id, audit_info, current_version, last_version, deleted_at) VALUES ( #{policyPO.policyId}, #{policyPO.policyName}, #{policyPO.policyType}, #{policyPO.metalakeId}, #{policyPO.auditInfo}, #{policyPO.currentVersion}, #{policyPO.lastVersion}, #{policyPO.deletedAt}) ON CONFLICT (policy_id) DO UPDATE SET policy_name = #{policyPO.policyName}, policy_type = #{policyPO.policyType}, metalake_id = #{policyPO.metalakeId}, audit_info = #{policyPO.auditInfo}, current_version = #{policyPO.currentVersion}, last_version = #{policyPO.lastVersion}, deleted_at = #{policyPO.deletedAt}";
    }
}

