/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.PolicyMetadataObjectRelBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.PolicyMetadataObjectRelPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.PolicyMetadataObjectRelPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class PolicyMetadataObjectRelSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, PolicyMetadataObjectRelBaseSQLProvider> POLICY_METADATA_OBJECT_RELATION_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new PolicyMetadataObjectRelMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new PolicyMetadataObjectRelH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new PolicyMetadataObjectRelPostgreSQLProvider());

    public static PolicyMetadataObjectRelBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return POLICY_METADATA_OBJECT_RELATION_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String listPolicyPOsByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().listPolicyPOsByMetadataObjectIdAndType(metadataObjectId, metadataObjectType);
    }

    public static String getPolicyPOsByMetadataObjectAndPolicyName(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType, @Param(value="policyName") String policyName) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().getPolicyPOsByMetadataObjectAndPolicyName(metadataObjectId, metadataObjectType, policyName);
    }

    public static String listPolicyMetadataObjectRelsByMetalakeAndPolicyName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().listPolicyMetadataObjectRelsByMetalakeAndPolicyName(metalakeName, policyName);
    }

    public static String batchInsertPolicyMetadataObjectRels(@Param(value="policyRels") List<PolicyMetadataObjectRelPO> policyRelPOs) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().batchInsertPolicyMetadataObjectRels(policyRelPOs);
    }

    public static String batchDeletePolicyMetadataObjectRelsByPolicyIdsAndMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType, @Param(value="policyIds") List<Long> policyIds) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().batchDeletePolicyMetadataObjectRelsByPolicyIdsAndMetadataObject(metadataObjectId, metadataObjectType, policyIds);
    }

    public static String softDeletePolicyMetadataObjectRelsByMetalakeAndPolicyName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().softDeletePolicyMetadataObjectRelsByMetalakeAndPolicyName(metalakeName, policyName);
    }

    public static String softDeletePolicyMetadataObjectRelsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().softDeletePolicyMetadataObjectRelsByMetalakeId(metalakeId);
    }

    public static String softDeletePolicyMetadataObjectRelsByMetadataObject(@Param(value="metadataObjectId") Long metadataObjectId, @Param(value="metadataObjectType") String metadataObjectType) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().softDeletePolicyMetadataObjectRelsByMetadataObject(metadataObjectId, metadataObjectType);
    }

    public static String softDeletePolicyMetadataObjectRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().softDeletePolicyMetadataObjectRelsByCatalogId(catalogId);
    }

    public static String softDeletePolicyMetadataObjectRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().softDeletePolicyMetadataObjectRelsBySchemaId(schemaId);
    }

    public static String softDeletePolicyMetadataObjectRelsByTableId(@Param(value="tableId") Long tableId) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().softDeletePolicyMetadataObjectRelsByTableId(tableId);
    }

    public static String deletePolicyEntityRelsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return PolicyMetadataObjectRelSQLProviderFactory.getProvider().deletePolicyEntityRelsByLegacyTimeline(legacyTimeline, limit);
    }

    static class PolicyMetadataObjectRelMySQLProvider
    extends PolicyMetadataObjectRelBaseSQLProvider {
        PolicyMetadataObjectRelMySQLProvider() {
        }
    }

    static class PolicyMetadataObjectRelH2Provider
    extends PolicyMetadataObjectRelBaseSQLProvider {
        PolicyMetadataObjectRelH2Provider() {
        }
    }
}

