/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.info;

import org.apache.gravitino.Audit;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.job.JobHandle;
import org.apache.gravitino.meta.JobEntity;

@DeveloperApi
public final class JobInfo {
    private final String jobId;
    private final String jobTemplateName;
    private final JobHandle.Status jobStatus;
    private final Audit audit;

    private JobInfo(String jobId, String jobTemplateName, JobHandle.Status jobStatus, Audit audit) {
        this.jobId = jobId;
        this.jobTemplateName = jobTemplateName;
        this.jobStatus = jobStatus;
        this.audit = audit;
    }

    public static JobInfo fromJobEntity(JobEntity jobEntity) {
        return new JobInfo(jobEntity.name(), jobEntity.jobTemplateName(), jobEntity.status(), jobEntity.auditInfo());
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobTemplateName() {
        return this.jobTemplateName;
    }

    public JobHandle.Status jobStatus() {
        return this.jobStatus;
    }

    public Audit auditInfo() {
        return this.audit;
    }
}

