/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.internal.util.ProductVersionUtil;
import org.apache.geode.internal.version.DistributionVersion;
import org.apache.geode.management.internal.cli.CliUtils;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.shell.GfshConfig;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.core.ExitShellRequest;

public class Launcher {
    private static final String EXECUTE_OPTION = "execute";
    private static final String HELP_OPTION = "help";
    private static final String HELP = "help";
    private static final String MSG_INVALID_COMMAND_OR_OPTION = "Invalid command or option : {0}." + GfshParser.LINE_SEPARATOR + "Use 'gfsh help' to display additional information.";
    public static final String SEPARATOR = ", ";
    private final Set<String> allowedCommandLineCommands;
    private final OptionParser commandLineParser;
    private final StartupTimeLogHelper startupTimeLogHelper = new StartupTimeLogHelper();

    protected Launcher() {
        this.allowedCommandLineCommands = new HashSet<String>();
        this.allowedCommandLineCommands.add("run");
        this.allowedCommandLineCommands.add("start pulse");
        this.allowedCommandLineCommands.add("start jconsole");
        this.allowedCommandLineCommands.add("start jvisualvm");
        this.allowedCommandLineCommands.add("start locator");
        this.allowedCommandLineCommands.add("start manager");
        this.allowedCommandLineCommands.add("start server");
        this.allowedCommandLineCommands.add("start vsd");
        this.allowedCommandLineCommands.add("status locator");
        this.allowedCommandLineCommands.add("status server");
        this.allowedCommandLineCommands.add("stop locator");
        this.allowedCommandLineCommands.add("stop server");
        this.allowedCommandLineCommands.add("version");
        this.allowedCommandLineCommands.add("compact offline-disk-store");
        this.allowedCommandLineCommands.add("describe offline-disk-store");
        this.allowedCommandLineCommands.add("export offline-disk-store");
        this.allowedCommandLineCommands.add("validate offline-disk-store");
        this.allowedCommandLineCommands.add("pdx delete-field");
        this.allowedCommandLineCommands.add("pdx rename");
        this.commandLineParser = new OptionParser();
        this.commandLineParser.accepts(EXECUTE_OPTION).withOptionalArg().ofType(String.class);
        this.commandLineParser.accepts("help").withOptionalArg().ofType(Boolean.class);
        this.commandLineParser.posixlyCorrect(false);
    }

    public static void main(String[] args) {
        String nonExistingDependency = CliUtils.cliDependenciesExist(true);
        if (nonExistingDependency != null) {
            System.err.println("Required (" + nonExistingDependency + ") libraries not found in the classpath. gfsh can't start.");
            return;
        }
        Launcher launcher = new Launcher();
        int exitValue = launcher.parseCommandLine(args);
        ExitCode.fromValue((int)exitValue).doSystemExit();
    }

    private int parseCommandLineCommand(String ... args) {
        Gfsh gfsh = null;
        try {
            gfsh = Gfsh.getInstance(false, args, new GfshConfig());
            this.startupTimeLogHelper.logStartupTime();
        }
        catch (IllegalStateException isex) {
            System.err.println("ERROR : " + isex.getMessage());
        }
        ExitShellRequest exitRequest = ExitShellRequest.NORMAL_EXIT;
        if (gfsh != null) {
            String commandLineCommand = this.combineStrings(args);
            if (commandLineCommand.startsWith("help")) {
                if (commandLineCommand.equals("help")) {
                    this.printUsage(gfsh, System.out);
                } else {
                    gfsh.executeCommand(commandLineCommand);
                }
            } else {
                boolean commandIsAllowed = false;
                for (String allowedCommandLineCommand : this.allowedCommandLineCommands) {
                    if (!commandLineCommand.startsWith(allowedCommandLineCommand)) continue;
                    commandIsAllowed = true;
                    break;
                }
                if (!commandIsAllowed) {
                    System.err.println(CliStrings.format((String)MSG_INVALID_COMMAND_OR_OPTION, (Object)StringUtils.join((Object[])args, (String)SEPARATOR)));
                    exitRequest = ExitShellRequest.FATAL_EXIT;
                } else if (!gfsh.executeScriptLine(commandLineCommand)) {
                    if (gfsh.getLastExecutionStatus() != 0) {
                        exitRequest = ExitShellRequest.FATAL_EXIT;
                    }
                } else if (gfsh.getLastExecutionStatus() != 0) {
                    exitRequest = ExitShellRequest.FATAL_EXIT;
                }
            }
        }
        return exitRequest.getExitCode();
    }

    private int parseOptions(String ... args) {
        OptionSet parsedOptions;
        try {
            parsedOptions = this.commandLineParser.parse(args);
        }
        catch (OptionException e) {
            System.err.println(CliStrings.format((String)MSG_INVALID_COMMAND_OR_OPTION, (Object)StringUtils.join((Object[])args, (String)SEPARATOR)));
            return ExitShellRequest.FATAL_EXIT.getExitCode();
        }
        boolean launchShell = true;
        boolean onlyPrintUsage = parsedOptions.has("help");
        if (parsedOptions.has(EXECUTE_OPTION) || onlyPrintUsage) {
            launchShell = false;
        }
        Gfsh gfsh = null;
        try {
            gfsh = Gfsh.getInstance(launchShell, args, new GfshConfig());
            this.startupTimeLogHelper.logStartupTime();
        }
        catch (IllegalStateException isex) {
            System.err.println("ERROR : " + isex.getMessage());
        }
        ExitShellRequest exitRequest = ExitShellRequest.NORMAL_EXIT;
        if (gfsh != null) {
            try {
                if (launchShell) {
                    gfsh.start();
                    gfsh.waitForComplete();
                    exitRequest = gfsh.getExitShellRequest();
                } else if (onlyPrintUsage) {
                    this.printUsage(gfsh, System.out);
                } else {
                    List commandsToExecute = parsedOptions.valuesOf(EXECUTE_OPTION);
                    for (int i = 0; i < commandsToExecute.size() && exitRequest == ExitShellRequest.NORMAL_EXIT; ++i) {
                        String command = (String)commandsToExecute.get(i);
                        System.out.println(GfshParser.LINE_SEPARATOR + "(" + (i + 1) + ") Executing - " + ArgumentRedactor.redact((String)command) + GfshParser.LINE_SEPARATOR);
                        if (gfsh.executeScriptLine(command) && gfsh.getLastExecutionStatus() == 0) continue;
                        exitRequest = ExitShellRequest.FATAL_EXIT;
                    }
                }
            }
            catch (InterruptedException iex) {
                this.log(iex, gfsh);
            }
        }
        return exitRequest.getExitCode();
    }

    private int parseCommandLine(String ... args) {
        if (args.length > 0 && !args[0].startsWith("-")) {
            return this.parseCommandLineCommand(args);
        }
        return this.parseOptions(args);
    }

    private void log(Throwable t, Gfsh gfsh) {
        if (gfsh == null || !gfsh.logToFile(t.getMessage(), t)) {
            t.printStackTrace();
        }
    }

    private String combineStrings(String ... strings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : strings) {
            stringBuilder.append(string).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    private void printUsage(Gfsh gfsh, PrintStream stream) {
        int terminalWidth = gfsh.getTerminalWidth();
        DistributionVersion distributionVersion = ProductVersionUtil.getDistributionVersion();
        stream.print(distributionVersion.getName() + " v");
        stream.print(distributionVersion.getVersion());
        stream.println(" Command Line Shell" + GfshParser.LINE_SEPARATOR);
        stream.println("USAGE");
        stream.println("gfsh [ <command> [option]* | <help> [command] | [--help | -h] | [-e \"<command> [option]*\"]* ]" + GfshParser.LINE_SEPARATOR);
        stream.println("OPTIONS");
        stream.println("-e  Execute a command");
        stream.println(Gfsh.wrapText("Commands may be any that are available from the interactive gfsh prompt.  For commands that require a Manager to complete, the first command in the list must be \"connect\".", 1, terminalWidth));
        stream.println("EXAMPLES");
        stream.println("gfsh");
        stream.println(Gfsh.wrapText("Start GFSH in interactive mode.", 1, terminalWidth));
        stream.println("gfsh -h");
        stream.println(Gfsh.wrapText("Displays 'this' help. ('gfsh --help' or 'gfsh help' is equivalent)", 1, terminalWidth));
        stream.println("gfsh help start locator");
        stream.println(Gfsh.wrapText("Display help for the \"start locator\" command.", 1, terminalWidth));
        stream.println("gfsh start locator --name=locator1");
        stream.println(Gfsh.wrapText("Start a Locator with the name \"locator1\".", 1, terminalWidth));
        stream.println("gfsh -e \"connect\" -e \"list members\"");
        stream.println(Gfsh.wrapText("Connect to a running Locator using the default connection information and run the \"list members\" command.", 1, terminalWidth));
        stream.println();
    }

    private static class StartupTimeLogHelper {
        private final long start = System.currentTimeMillis();
        private long done;

        private StartupTimeLogHelper() {
        }

        public void logStartupTime() {
            this.done = System.currentTimeMillis();
            LogWrapper.getInstance(null).info("Startup done in " + (double)(this.done - this.start) / 1000.0 + " seconds.");
        }

        public String toString() {
            return StartupTimeLogHelper.class.getName() + " [start=" + this.start + ", done=" + this.done + "]";
        }
    }
}

