/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.DataSerializer;
import org.apache.geode.LogWriter;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheCallback;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.client.ServerRefusedConnectionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.internal.ClassLoadUtils;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.tier.ConnectionProxy;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.EncryptorImpl;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.security.CallbackInstantiator;
import org.apache.geode.internal.security.Credentials;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.AuthInitialize;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.Authenticator;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.subject.Subject;

public abstract class Handshake {
    private static final Logger logger = LogService.getLogger();
    protected static final byte REPLY_OK = 59;
    protected static final byte REPLY_REFUSED = 60;
    protected static final byte REPLY_INVALID = 61;
    protected static final byte REPLY_EXCEPTION_AUTHENTICATION_REQUIRED = 62;
    protected static final byte REPLY_EXCEPTION_AUTHENTICATION_FAILED = 63;
    protected static final byte REPLY_EXCEPTION_DUPLICATE_DURABLE_CLIENT = 64;
    protected static final byte REPLY_WAN_CREDENTIALS = 65;
    protected static final byte REPLY_AUTH_NOT_REQUIRED = 66;
    public static final byte REPLY_SERVER_IS_LOCATOR = 67;
    @MutableForTesting
    protected static KnownVersion currentClientVersion = ConnectionProxy.VERSION;
    protected SecurityService securityService;
    protected int clientReadTimeout = 10000;
    protected DistributedSystem system;
    protected ClientProxyMembershipID id;
    protected Properties credentials;
    protected EncryptorImpl encryptor;
    public static final byte CREDENTIALS_NONE = 0;
    public static final byte CREDENTIALS_NORMAL = 1;
    public static final byte CREDENTIALS_DHENCRYPT = 2;
    public static final byte SECURITY_MULTIUSER_NOTIFICATIONCHANNEL = 3;
    public static final String PUBLIC_KEY_FILE_PROP = "security-client-kspath";
    public static final String PUBLIC_KEY_PASSWD_PROP = "security-client-kspasswd";
    public static final String PRIVATE_KEY_FILE_PROP = "security-server-kspath";
    public static final String PRIVATE_KEY_ALIAS_PROP = "security-server-ksalias";
    public static final String PRIVATE_KEY_PASSWD_PROP = "security-server-kspasswd";
    public static final byte CONFLATION_DEFAULT = 0;
    public static final byte CONFLATION_ON = 1;
    public static final byte CONFLATION_OFF = 2;
    protected byte clientConflation = 0;
    protected byte[] overrides;
    public static final byte clientConflationForTesting = 0;
    public static final boolean setClientConflationForTesting = false;

    protected abstract byte getReplyCode();

    protected Handshake() {
    }

    protected Handshake(Handshake handshake) {
        this.clientConflation = handshake.clientConflation;
        this.clientReadTimeout = handshake.clientReadTimeout;
        this.credentials = handshake.credentials;
        this.overrides = handshake.overrides;
        this.system = handshake.system;
        this.id = handshake.id;
        this.securityService = handshake.securityService;
        this.encryptor = new EncryptorImpl(handshake.encryptor);
    }

    protected void setClientConflation(byte value) {
        this.clientConflation = value;
        switch (this.clientConflation) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal clientConflation");
            }
        }
    }

    protected byte[] getOverrides() {
        return this.overrides;
    }

    protected void setOverrides(byte[] values) {
        byte override = values[0];
        this.setClientConflation((byte)(override & 3));
    }

    public static byte[] extractOverrides(byte[] values) {
        byte override = values[0];
        byte[] overrides = new byte[1];
        for (int item = 0; item < overrides.length; ++item) {
            overrides[item] = (byte)(override & 3);
            override = (byte)(override >>> 2);
        }
        return overrides;
    }

    protected byte writeCredential(DataOutputStream dos, DataInputStream dis, String authInit, boolean isNotification, DistributedMember member, HeapDataOutputStream heapdos) throws IOException, GemFireSecurityException {
        if (!this.encryptor.isEnabled()) {
            heapdos.writeByte(1);
            this.encryptor.setAppSecureMode((byte)1);
            heapdos.flush();
            dos.write(heapdos.toByteArray());
            dos.flush();
            return -1;
        }
        byte acceptanceCode = -1;
        acceptanceCode = this.encryptor.writeEncryptedCredential(dos, dis, heapdos);
        if (acceptanceCode != 59 && acceptanceCode != 66) {
            dis.readByte();
            dis.readInt();
            if (!isNotification) {
                DataSerializer.readByteArray(dis);
            }
            this.readMessage(dis, dos, acceptanceCode, member);
        }
        dos.flush();
        return acceptanceCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCredentials(DataOutputStream dos, DataInputStream dis, Properties p_credentials, boolean isNotification, DistributedMember member) throws IOException, GemFireSecurityException {
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(32, KnownVersion.CURRENT);){
            this.writeCredentials(dos, dis, p_credentials, isNotification, member, hdos);
        }
    }

    public void writeCredentials(DataOutputStream dos, DataInputStream dis, Properties p_credentials, boolean isNotification, DistributedMember member, HeapDataOutputStream heapdos) throws IOException, GemFireSecurityException {
        if (p_credentials == null) {
            heapdos.writeByte(0);
            heapdos.flush();
            dos.write(heapdos.toByteArray());
            dos.flush();
            return;
        }
        if (!this.encryptor.isEnabled()) {
            heapdos.writeByte(1);
            DataSerializer.writeProperties(p_credentials, heapdos);
            heapdos.flush();
            dos.write(heapdos.toByteArray());
            dos.flush();
            return;
        }
        byte acceptanceCode = this.encryptor.writeEncryptedCredentials(dos, dis, p_credentials, heapdos);
        if (acceptanceCode != 59 && acceptanceCode != 66) {
            dis.readByte();
            dis.readInt();
            if (!isNotification) {
                DataSerializer.readByteArray(dis);
            }
            this.readMessage(dis, dos, acceptanceCode, member);
        }
        dos.flush();
    }

    static void throwIfMissingRequiredCredentials(boolean requireAuthentication, boolean hasCredentials) {
        if (requireAuthentication && !hasCredentials) {
            throw new AuthenticationRequiredException("No security credentials are provided");
        }
    }

    Properties readCredential(DataInputStream dis, DataOutputStream dos, DistributedSystem system) throws GemFireSecurityException, IOException {
        Properties credentials = null;
        boolean requireAuthentication = this.securityService.isClientSecurityRequired();
        try {
            byte secureMode = dis.readByte();
            Handshake.throwIfMissingRequiredCredentials(requireAuthentication, secureMode != 0);
            if (secureMode == 1) {
                this.encryptor.setAppSecureMode((byte)1);
            } else if (secureMode == 2) {
                this.encryptor.readEncryptedCredentials(dis, dos, system, requireAuthentication);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (GemFireSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AuthenticationFailedException("Failure in reading credentials", ex);
        }
        return credentials;
    }

    protected void readMessage(DataInputStream dis, DataOutputStream dos, byte acceptanceCode, DistributedMember member) throws IOException, AuthenticationRequiredException, AuthenticationFailedException, ServerRefusedConnectionException {
        String message = dis.readUTF();
        if (message.length() == 0 && acceptanceCode != 65) {
            return;
        }
        switch (acceptanceCode) {
            case 62: {
                throw new AuthenticationRequiredException(message);
            }
            case 63: {
                throw new AuthenticationFailedException(message);
            }
            case 64: {
                throw new ServerRefusedConnectionException(member, message);
            }
            case 65: {
                this.checkIfAuthenticWanSite(dis, dos, member);
                break;
            }
            default: {
                throw new ServerRefusedConnectionException(member, message);
            }
        }
    }

    public boolean isOK() {
        return this.getReplyCode() == 59;
    }

    public void setClientReadTimeout(int clientReadTimeout) {
        this.clientReadTimeout = clientReadTimeout;
    }

    public int getClientReadTimeout() {
        return this.clientReadTimeout;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Handshake)) {
            return false;
        }
        Handshake that = (Handshake)other;
        return this.id.isSameDSMember(that.id) && this.getReplyCode() == that.getReplyCode();
    }

    public int hashCode() {
        int mult = 37;
        int result = this.id.hashCode();
        result = 37 * result + this.getReplyCode();
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("HandShake@").append(System.identityHashCode(this)).append(" code: ").append(this.getReplyCode());
        if (this.id != null) {
            buf.append(" identity: ");
            buf.append(this.id);
        }
        return buf.toString();
    }

    public ClientProxyMembershipID getMembershipId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getCredentials(String authInitMethod, Properties securityProperties, DistributedMember server, boolean isPeer, LogWriter logWriter, LogWriter securityLogWriter) throws AuthenticationRequiredException {
        Properties credentials = null;
        if (StringUtils.isBlank((CharSequence)authInitMethod)) {
            return Credentials.getCredentials(securityProperties);
        }
        try {
            auth.init(logWriter, securityLogWriter);
            try (AuthInitialize auth = CallbackInstantiator.getObjectOfType(authInitMethod, AuthInitialize.class);){
                credentials = auth.getCredentials(securityProperties, server, isPeer);
            }
        }
        catch (GemFireSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AuthenticationRequiredException(String.format("Failed to acquire AuthInitialize method %s", authInitMethod), ex);
        }
        return credentials;
    }

    protected Properties getCredentials(DistributedMember member) {
        String authInitMethod = this.system.getProperties().getProperty("security-client-auth-init");
        return Handshake.getCredentials(authInitMethod, this.system.getSecurityProperties(), member, false, this.system.getLogWriter(), this.system.getSecurityLogWriter());
    }

    public static Properties readCredentials(DataInputStream dis, DataOutputStream dos, DistributedSystem system, SecurityService securityService) throws GemFireSecurityException, IOException {
        boolean requireAuthentication = securityService.isClientSecurityRequired();
        Properties credentials = null;
        try {
            byte secureMode = dis.readByte();
            Handshake.throwIfMissingRequiredCredentials(requireAuthentication, secureMode != 0);
            if (secureMode == 1) {
                if (requireAuthentication) {
                    credentials = DataSerializer.readProperties(dis);
                } else {
                    DataSerializer.readProperties(dis);
                }
            } else if (secureMode == 2) {
                credentials = EncryptorImpl.getDecryptedCredentials(dis, dos, system, requireAuthentication, credentials);
            } else if (secureMode == 3) {
                logger.debug("readCredential where multiuser mode creating callback connection");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (GemFireSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AuthenticationFailedException("Failure in reading credentials", ex);
        }
        return credentials;
    }

    public static Object verifyCredentials(String authenticatorMethod, Properties credentials, Properties securityProperties, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, DistributedMember member, SecurityService securityService) throws AuthenticationRequiredException, AuthenticationFailedException, CacheClosedException {
        if (!AcceptorImpl.isAuthenticationRequired()) {
            return null;
        }
        return Handshake.authenticate(authenticatorMethod, credentials, securityProperties, logWriter, securityLogWriter, member, securityService);
    }

    @VisibleForTesting
    static Object authenticate(String authenticatorMethod, Properties credentials, Properties securityProperties, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, DistributedMember member, SecurityService securityService) {
        try (CacheCallback auth = null;){
            if (securityService.isIntegratedSecurity()) {
                Subject subject = securityService.login(credentials);
                return subject;
            }
            Method instanceGetter = ClassLoadUtils.methodFromName(authenticatorMethod);
            auth = (Authenticator)instanceGetter.invoke(null, (Object[])null);
            auth.init(securityProperties, logWriter, securityLogWriter);
            Principal principal = auth.authenticate(credentials, member);
            return principal;
        }
    }

    public Object verifyCredentials() throws AuthenticationRequiredException, AuthenticationFailedException {
        String methodName = this.system.getProperties().getProperty("security-client-authenticator");
        return Handshake.verifyCredentials(methodName, this.credentials, this.system.getSecurityProperties(), (InternalLogWriter)this.system.getLogWriter(), (InternalLogWriter)this.system.getSecurityLogWriter(), this.id.getDistributedMember(), this.securityService);
    }

    private void checkIfAuthenticWanSite(DataInputStream dis, DataOutputStream dos, DistributedMember member) throws GemFireSecurityException, IOException {
        if (this.credentials == null) {
            return;
        }
        String authenticator = this.system.getProperties().getProperty("security-client-authenticator");
        Properties peerWanProps = Handshake.readCredentials(dis, dos, this.system, this.securityService);
        Handshake.verifyCredentials(authenticator, peerWanProps, this.system.getSecurityProperties(), (InternalLogWriter)this.system.getLogWriter(), (InternalLogWriter)this.system.getSecurityLogWriter(), member, this.securityService);
    }
}

