/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import java.util.Map;
import java.util.Set;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.PartitionRebalanceDetailsImpl;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.cache.partitioned.rebalance.BucketOperator;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class BucketOperatorWrapper
implements BucketOperator {
    private static final Logger logger = LogService.getLogger();
    private final BucketOperator delegate;
    private final Set<PartitionRebalanceDetailsImpl> detailSet;
    private final int regionCount;
    private final ResourceManagerStats stats;
    private final PartitionedRegion leaderRegion;

    public BucketOperatorWrapper(BucketOperator delegate, Set<PartitionRebalanceDetailsImpl> rebalanceDetails, ResourceManagerStats stats, PartitionedRegion leaderRegion) {
        this.delegate = delegate;
        this.detailSet = rebalanceDetails;
        this.regionCount = this.detailSet.size();
        this.stats = stats;
        this.leaderRegion = leaderRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveBucket(InternalDistributedMember sourceMember, InternalDistributedMember targetMember, int id, Map<String, Long> colocatedRegionBytes) {
        long start = System.nanoTime();
        boolean result = false;
        long elapsed = 0L;
        long totalBytes = 0L;
        if (this.stats != null) {
            this.stats.startBucketTransfer(this.regionCount);
        }
        try {
            result = this.delegate.moveBucket(sourceMember, targetMember, id, colocatedRegionBytes);
            elapsed = System.nanoTime() - start;
            if (result) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Rebalancing {} bucket {} moved from {} to {}", (Object)this.leaderRegion, (Object)id, (Object)sourceMember, (Object)targetMember);
                }
                for (PartitionRebalanceDetailsImpl details : this.detailSet) {
                    String regionPath = details.getRegionPath();
                    Long regionBytes = colocatedRegionBytes.get(regionPath);
                    if (regionBytes == null) continue;
                    details.incTransfers(regionBytes, details.getRegion().equals(this.leaderRegion) ? elapsed : 0L);
                    totalBytes += regionBytes.longValue();
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Rebalancing {} bucket {} moved failed from {} to {}", (Object)this.leaderRegion, (Object)id, (Object)sourceMember, (Object)targetMember);
            }
        }
        finally {
            if (this.stats != null) {
                this.stats.endBucketTransfer(this.regionCount, result, totalBytes, elapsed);
            }
        }
        return result;
    }

    @Override
    public void createRedundantBucket(final InternalDistributedMember targetMember, final int i, final Map<String, Long> colocatedRegionBytes, final BucketOperator.Completion completion) {
        if (this.stats != null) {
            this.stats.startBucketCreate(this.regionCount);
        }
        final long start = System.nanoTime();
        this.delegate.createRedundantBucket(targetMember, i, colocatedRegionBytes, new BucketOperator.Completion(){

            @Override
            public void onSuccess() {
                long totalBytes = 0L;
                long elapsed = System.nanoTime() - start;
                if (logger.isDebugEnabled()) {
                    logger.debug("Rebalancing {} redundant bucket {} created on {}", (Object)BucketOperatorWrapper.this.leaderRegion, (Object)i, (Object)targetMember);
                }
                for (PartitionRebalanceDetailsImpl details : BucketOperatorWrapper.this.detailSet) {
                    String regionPath = details.getRegionPath();
                    Long lrb = (Long)colocatedRegionBytes.get(regionPath);
                    if (lrb == null) continue;
                    long regionBytes = lrb;
                    details.incCreates(regionBytes, details.getRegion().equals(BucketOperatorWrapper.this.leaderRegion) ? elapsed : 0L);
                    totalBytes += regionBytes;
                }
                if (BucketOperatorWrapper.this.stats != null) {
                    BucketOperatorWrapper.this.stats.endBucketCreate(BucketOperatorWrapper.this.regionCount, true, totalBytes, elapsed);
                }
                completion.onSuccess();
            }

            @Override
            public void onFailure() {
                long elapsed = System.nanoTime() - start;
                if (logger.isDebugEnabled()) {
                    logger.info("Rebalancing {} redundant bucket {} failed creation on {}", (Object)BucketOperatorWrapper.this.leaderRegion, (Object)i, (Object)targetMember);
                }
                if (BucketOperatorWrapper.this.stats != null) {
                    BucketOperatorWrapper.this.stats.endBucketCreate(BucketOperatorWrapper.this.regionCount, false, 0L, elapsed);
                }
                completion.onFailure();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeBucket(InternalDistributedMember targetMember, int i, Map<String, Long> colocatedRegionBytes) {
        boolean result = false;
        long elapsed = 0L;
        long totalBytes = 0L;
        if (this.stats != null) {
            this.stats.startBucketRemove(this.regionCount);
        }
        try {
            long start = System.nanoTime();
            result = this.delegate.removeBucket(targetMember, i, colocatedRegionBytes);
            elapsed = System.nanoTime() - start;
            if (result) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Rebalancing {} redundant bucket {} removed from {}", (Object)this.leaderRegion, (Object)i, (Object)targetMember);
                }
                for (PartitionRebalanceDetailsImpl details : this.detailSet) {
                    String regionPath = details.getRegionPath();
                    Long lrb = colocatedRegionBytes.get(regionPath);
                    if (lrb == null) continue;
                    long regionBytes = lrb;
                    details.incRemoves(regionBytes, details.getRegion().equals(this.leaderRegion) ? elapsed : 0L);
                    totalBytes += regionBytes;
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Rebalancing {} redundant bucket {} failed removal o{}", (Object)this.leaderRegion, (Object)i, (Object)targetMember);
            }
        }
        finally {
            if (this.stats != null) {
                this.stats.endBucketRemove(this.regionCount, result, totalBytes, elapsed);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean movePrimary(InternalDistributedMember source, InternalDistributedMember target, int bucketId) {
        boolean result = false;
        long elapsed = 0L;
        if (this.stats != null) {
            this.stats.startPrimaryTransfer(this.regionCount);
        }
        try {
            long start = System.nanoTime();
            result = this.delegate.movePrimary(source, target, bucketId);
            elapsed = System.nanoTime() - start;
            if (result) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Rebalancing {} primary bucket {} moved from {} to {}", (Object)this.leaderRegion, (Object)bucketId, (Object)source, (Object)target);
                }
                for (PartitionRebalanceDetailsImpl details : this.detailSet) {
                    details.incPrimaryTransfers(details.getRegion().equals(this.leaderRegion) ? elapsed : 0L);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Rebalancing {} primary bucket {} failed to move from {} to {}", (Object)this.leaderRegion, (Object)bucketId, (Object)source, (Object)target);
            }
        }
        finally {
            if (this.stats != null) {
                this.stats.endPrimaryTransfer(this.regionCount, result, elapsed);
            }
        }
        return result;
    }

    @Override
    public void waitForOperations() {
        this.delegate.waitForOperations();
    }

    public Set<PartitionRebalanceDetailsImpl> getDetailSet() {
        return this.detailSet;
    }
}

